/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.Destination;
import software.amazon.awssdk.services.efs.model.DestinationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationConfigurationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationConfigurationDescription> {
    private static final SdkField<String> SOURCE_FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFileSystemId").getter(ReplicationConfigurationDescription.getter(ReplicationConfigurationDescription::sourceFileSystemId)).setter(ReplicationConfigurationDescription.setter(Builder::sourceFileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileSystemId").build()}).build();
    private static final SdkField<String> SOURCE_FILE_SYSTEM_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFileSystemRegion").getter(ReplicationConfigurationDescription.getter(ReplicationConfigurationDescription::sourceFileSystemRegion)).setter(ReplicationConfigurationDescription.setter(Builder::sourceFileSystemRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileSystemRegion").build()}).build();
    private static final SdkField<String> SOURCE_FILE_SYSTEM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFileSystemArn").getter(ReplicationConfigurationDescription.getter(ReplicationConfigurationDescription::sourceFileSystemArn)).setter(ReplicationConfigurationDescription.setter(Builder::sourceFileSystemArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileSystemArn").build()}).build();
    private static final SdkField<String> ORIGINAL_SOURCE_FILE_SYSTEM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginalSourceFileSystemArn").getter(ReplicationConfigurationDescription.getter(ReplicationConfigurationDescription::originalSourceFileSystemArn)).setter(ReplicationConfigurationDescription.setter(Builder::originalSourceFileSystemArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalSourceFileSystemArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ReplicationConfigurationDescription.getter(ReplicationConfigurationDescription::creationTime)).setter(ReplicationConfigurationDescription.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<List<Destination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(ReplicationConfigurationDescription.getter(ReplicationConfigurationDescription::destinations)).setter(ReplicationConfigurationDescription.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FILE_SYSTEM_ID_FIELD, SOURCE_FILE_SYSTEM_REGION_FIELD, SOURCE_FILE_SYSTEM_ARN_FIELD, ORIGINAL_SOURCE_FILE_SYSTEM_ARN_FIELD, CREATION_TIME_FIELD, DESTINATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceFileSystemId;
    private final String sourceFileSystemRegion;
    private final String sourceFileSystemArn;
    private final String originalSourceFileSystemArn;
    private final Instant creationTime;
    private final List<Destination> destinations;

    private ReplicationConfigurationDescription(BuilderImpl builder) {
        this.sourceFileSystemId = builder.sourceFileSystemId;
        this.sourceFileSystemRegion = builder.sourceFileSystemRegion;
        this.sourceFileSystemArn = builder.sourceFileSystemArn;
        this.originalSourceFileSystemArn = builder.originalSourceFileSystemArn;
        this.creationTime = builder.creationTime;
        this.destinations = builder.destinations;
    }

    public final String sourceFileSystemId() {
        return this.sourceFileSystemId;
    }

    public final String sourceFileSystemRegion() {
        return this.sourceFileSystemRegion;
    }

    public final String sourceFileSystemArn() {
        return this.sourceFileSystemArn;
    }

    public final String originalSourceFileSystemArn() {
        return this.originalSourceFileSystemArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<Destination> destinations() {
        return this.destinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileSystemRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalSourceFileSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationConfigurationDescription)) {
            return false;
        }
        ReplicationConfigurationDescription other = (ReplicationConfigurationDescription)obj;
        return Objects.equals(this.sourceFileSystemId(), other.sourceFileSystemId()) && Objects.equals(this.sourceFileSystemRegion(), other.sourceFileSystemRegion()) && Objects.equals(this.sourceFileSystemArn(), other.sourceFileSystemArn()) && Objects.equals(this.originalSourceFileSystemArn(), other.originalSourceFileSystemArn()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationConfigurationDescription").add("SourceFileSystemId", (Object)this.sourceFileSystemId()).add("SourceFileSystemRegion", (Object)this.sourceFileSystemRegion()).add("SourceFileSystemArn", (Object)this.sourceFileSystemArn()).add("OriginalSourceFileSystemArn", (Object)this.originalSourceFileSystemArn()).add("CreationTime", (Object)this.creationTime()).add("Destinations", this.hasDestinations() ? this.destinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceFileSystemId": {
                return Optional.ofNullable(clazz.cast(this.sourceFileSystemId()));
            }
            case "SourceFileSystemRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceFileSystemRegion()));
            }
            case "SourceFileSystemArn": {
                return Optional.ofNullable(clazz.cast(this.sourceFileSystemArn()));
            }
            case "OriginalSourceFileSystemArn": {
                return Optional.ofNullable(clazz.cast(this.originalSourceFileSystemArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationConfigurationDescription, T> g) {
        return obj -> g.apply((ReplicationConfigurationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceFileSystemId;
        private String sourceFileSystemRegion;
        private String sourceFileSystemArn;
        private String originalSourceFileSystemArn;
        private Instant creationTime;
        private List<Destination> destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationConfigurationDescription model) {
            this.sourceFileSystemId(model.sourceFileSystemId);
            this.sourceFileSystemRegion(model.sourceFileSystemRegion);
            this.sourceFileSystemArn(model.sourceFileSystemArn);
            this.originalSourceFileSystemArn(model.originalSourceFileSystemArn);
            this.creationTime(model.creationTime);
            this.destinations(model.destinations);
        }

        public final String getSourceFileSystemId() {
            return this.sourceFileSystemId;
        }

        public final void setSourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
        }

        @Override
        public final Builder sourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
            return this;
        }

        public final String getSourceFileSystemRegion() {
            return this.sourceFileSystemRegion;
        }

        public final void setSourceFileSystemRegion(String sourceFileSystemRegion) {
            this.sourceFileSystemRegion = sourceFileSystemRegion;
        }

        @Override
        public final Builder sourceFileSystemRegion(String sourceFileSystemRegion) {
            this.sourceFileSystemRegion = sourceFileSystemRegion;
            return this;
        }

        public final String getSourceFileSystemArn() {
            return this.sourceFileSystemArn;
        }

        public final void setSourceFileSystemArn(String sourceFileSystemArn) {
            this.sourceFileSystemArn = sourceFileSystemArn;
        }

        @Override
        public final Builder sourceFileSystemArn(String sourceFileSystemArn) {
            this.sourceFileSystemArn = sourceFileSystemArn;
            return this;
        }

        public final String getOriginalSourceFileSystemArn() {
            return this.originalSourceFileSystemArn;
        }

        public final void setOriginalSourceFileSystemArn(String originalSourceFileSystemArn) {
            this.originalSourceFileSystemArn = originalSourceFileSystemArn;
        }

        @Override
        public final Builder originalSourceFileSystemArn(String originalSourceFileSystemArn) {
            this.originalSourceFileSystemArn = originalSourceFileSystemArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<Destination.Builder> getDestinations() {
            List<Destination.Builder> result = DestinationsCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<Destination.BuilderImpl> destinations) {
            this.destinations = DestinationsCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<Destination> destinations) {
            this.destinations = DestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Destination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<Destination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (Destination)((Destination.Builder)Destination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ReplicationConfigurationDescription build() {
            return new ReplicationConfigurationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationConfigurationDescription> {
        public Builder sourceFileSystemId(String var1);

        public Builder sourceFileSystemRegion(String var1);

        public Builder sourceFileSystemArn(String var1);

        public Builder originalSourceFileSystemArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder destinations(Collection<Destination> var1);

        public Builder destinations(Destination ... var1);

        public Builder destinations(Consumer<Destination.Builder> ... var1);
    }
}

