/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LifeCycleState {
    CREATING("creating"),
    AVAILABLE("available"),
    UPDATING("updating"),
    DELETING("deleting"),
    DELETED("deleted"),
    ERROR("error"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LifeCycleState> VALUE_MAP;
    private final String value;

    private LifeCycleState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LifeCycleState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LifeCycleState> knownValues() {
        EnumSet<LifeCycleState> knownValues = EnumSet.allOf(LifeCycleState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LifeCycleState.class, LifeCycleState::toString);
    }
}

