/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SettingName {
    SERVICE_LONG_ARN_FORMAT("serviceLongArnFormat"),
    TASK_LONG_ARN_FORMAT("taskLongArnFormat"),
    CONTAINER_INSTANCE_LONG_ARN_FORMAT("containerInstanceLongArnFormat"),
    AWSVPC_TRUNKING("awsvpcTrunking"),
    CONTAINER_INSIGHTS("containerInsights"),
    FARGATE_FIPS_MODE("fargateFIPSMode"),
    TAG_RESOURCE_AUTHORIZATION("tagResourceAuthorization"),
    FARGATE_TASK_RETIREMENT_WAIT_PERIOD("fargateTaskRetirementWaitPeriod"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SettingName> VALUE_MAP;
    private final String value;

    private SettingName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SettingName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SettingName> knownValues() {
        EnumSet<SettingName> knownValues = EnumSet.allOf(SettingName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SettingName.class, SettingName::toString);
    }
}

