/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteCommandLogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecuteCommandLogConfiguration> {
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudWatchLogGroupName").getter(ExecuteCommandLogConfiguration.getter(ExecuteCommandLogConfiguration::cloudWatchLogGroupName)).setter(ExecuteCommandLogConfiguration.setter(Builder::cloudWatchLogGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogGroupName").build()}).build();
    private static final SdkField<Boolean> CLOUD_WATCH_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("cloudWatchEncryptionEnabled").getter(ExecuteCommandLogConfiguration.getter(ExecuteCommandLogConfiguration::cloudWatchEncryptionEnabled)).setter(ExecuteCommandLogConfiguration.setter(Builder::cloudWatchEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchEncryptionEnabled").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketName").getter(ExecuteCommandLogConfiguration.getter(ExecuteCommandLogConfiguration::s3BucketName)).setter(ExecuteCommandLogConfiguration.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()}).build();
    private static final SdkField<Boolean> S3_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("s3EncryptionEnabled").getter(ExecuteCommandLogConfiguration.getter(ExecuteCommandLogConfiguration::s3EncryptionEnabled)).setter(ExecuteCommandLogConfiguration.setter(Builder::s3EncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3EncryptionEnabled").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3KeyPrefix").getter(ExecuteCommandLogConfiguration.getter(ExecuteCommandLogConfiguration::s3KeyPrefix)).setter(ExecuteCommandLogConfiguration.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3KeyPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOG_GROUP_NAME_FIELD, CLOUD_WATCH_ENCRYPTION_ENABLED_FIELD, S3_BUCKET_NAME_FIELD, S3_ENCRYPTION_ENABLED_FIELD, S3_KEY_PREFIX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cloudWatchLogGroupName;
    private final Boolean cloudWatchEncryptionEnabled;
    private final String s3BucketName;
    private final Boolean s3EncryptionEnabled;
    private final String s3KeyPrefix;

    private ExecuteCommandLogConfiguration(BuilderImpl builder) {
        this.cloudWatchLogGroupName = builder.cloudWatchLogGroupName;
        this.cloudWatchEncryptionEnabled = builder.cloudWatchEncryptionEnabled;
        this.s3BucketName = builder.s3BucketName;
        this.s3EncryptionEnabled = builder.s3EncryptionEnabled;
        this.s3KeyPrefix = builder.s3KeyPrefix;
    }

    public final String cloudWatchLogGroupName() {
        return this.cloudWatchLogGroupName;
    }

    public final Boolean cloudWatchEncryptionEnabled() {
        return this.cloudWatchEncryptionEnabled;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final Boolean s3EncryptionEnabled() {
        return this.s3EncryptionEnabled;
    }

    public final String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3EncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteCommandLogConfiguration)) {
            return false;
        }
        ExecuteCommandLogConfiguration other = (ExecuteCommandLogConfiguration)obj;
        return Objects.equals(this.cloudWatchLogGroupName(), other.cloudWatchLogGroupName()) && Objects.equals(this.cloudWatchEncryptionEnabled(), other.cloudWatchEncryptionEnabled()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3EncryptionEnabled(), other.s3EncryptionEnabled()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteCommandLogConfiguration").add("CloudWatchLogGroupName", (Object)this.cloudWatchLogGroupName()).add("CloudWatchEncryptionEnabled", (Object)this.cloudWatchEncryptionEnabled()).add("S3BucketName", (Object)this.s3BucketName()).add("S3EncryptionEnabled", (Object)this.s3EncryptionEnabled()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchLogGroupName": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupName()));
            }
            case "cloudWatchEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchEncryptionEnabled()));
            }
            case "s3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "s3EncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.s3EncryptionEnabled()));
            }
            case "s3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteCommandLogConfiguration, T> g) {
        return obj -> g.apply((ExecuteCommandLogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudWatchLogGroupName;
        private Boolean cloudWatchEncryptionEnabled;
        private String s3BucketName;
        private Boolean s3EncryptionEnabled;
        private String s3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteCommandLogConfiguration model) {
            this.cloudWatchLogGroupName(model.cloudWatchLogGroupName);
            this.cloudWatchEncryptionEnabled(model.cloudWatchEncryptionEnabled);
            this.s3BucketName(model.s3BucketName);
            this.s3EncryptionEnabled(model.s3EncryptionEnabled);
            this.s3KeyPrefix(model.s3KeyPrefix);
        }

        public final String getCloudWatchLogGroupName() {
            return this.cloudWatchLogGroupName;
        }

        public final void setCloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
        }

        @Override
        public final Builder cloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
            return this;
        }

        public final Boolean getCloudWatchEncryptionEnabled() {
            return this.cloudWatchEncryptionEnabled;
        }

        public final void setCloudWatchEncryptionEnabled(Boolean cloudWatchEncryptionEnabled) {
            this.cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled;
        }

        @Override
        public final Builder cloudWatchEncryptionEnabled(Boolean cloudWatchEncryptionEnabled) {
            this.cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled;
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final Boolean getS3EncryptionEnabled() {
            return this.s3EncryptionEnabled;
        }

        public final void setS3EncryptionEnabled(Boolean s3EncryptionEnabled) {
            this.s3EncryptionEnabled = s3EncryptionEnabled;
        }

        @Override
        public final Builder s3EncryptionEnabled(Boolean s3EncryptionEnabled) {
            this.s3EncryptionEnabled = s3EncryptionEnabled;
            return this;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public ExecuteCommandLogConfiguration build() {
            return new ExecuteCommandLogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecuteCommandLogConfiguration> {
        public Builder cloudWatchLogGroupName(String var1);

        public Builder cloudWatchEncryptionEnabled(Boolean var1);

        public Builder s3BucketName(String var1);

        public Builder s3EncryptionEnabled(Boolean var1);

        public Builder s3KeyPrefix(String var1);
    }
}

