/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.Failure;
import software.amazon.awssdk.services.ecs.model.FailuresCopier;
import software.amazon.awssdk.services.ecs.model.ProtectedTask;
import software.amazon.awssdk.services.ecs.model.ProtectedTasksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTaskProtectionResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, GetTaskProtectionResponse> {
    private static final SdkField<List<ProtectedTask>> PROTECTED_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("protectedTasks").getter(GetTaskProtectionResponse.getter(GetTaskProtectionResponse::protectedTasks)).setter(GetTaskProtectionResponse.setter(Builder::protectedTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedTasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProtectedTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Failure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failures").getter(GetTaskProtectionResponse.getter(GetTaskProtectionResponse::failures)).setter(GetTaskProtectionResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Failure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTED_TASKS_FIELD, FAILURES_FIELD));
    private final List<ProtectedTask> protectedTasks;
    private final List<Failure> failures;

    private GetTaskProtectionResponse(BuilderImpl builder) {
        super(builder);
        this.protectedTasks = builder.protectedTasks;
        this.failures = builder.failures;
    }

    public final boolean hasProtectedTasks() {
        return this.protectedTasks != null && !(this.protectedTasks instanceof SdkAutoConstructList);
    }

    public final List<ProtectedTask> protectedTasks() {
        return this.protectedTasks;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<Failure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtectedTasks() ? this.protectedTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTaskProtectionResponse)) {
            return false;
        }
        GetTaskProtectionResponse other = (GetTaskProtectionResponse)((Object)obj);
        return this.hasProtectedTasks() == other.hasProtectedTasks() && Objects.equals(this.protectedTasks(), other.protectedTasks()) && this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures());
    }

    public final String toString() {
        return ToString.builder((String)"GetTaskProtectionResponse").add("ProtectedTasks", this.hasProtectedTasks() ? this.protectedTasks() : null).add("Failures", this.hasFailures() ? this.failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "protectedTasks": {
                return Optional.ofNullable(clazz.cast(this.protectedTasks()));
            }
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTaskProtectionResponse, T> g) {
        return obj -> g.apply((GetTaskProtectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<ProtectedTask> protectedTasks = DefaultSdkAutoConstructList.getInstance();
        private List<Failure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTaskProtectionResponse model) {
            super(model);
            this.protectedTasks(model.protectedTasks);
            this.failures(model.failures);
        }

        public final List<ProtectedTask.Builder> getProtectedTasks() {
            List<ProtectedTask.Builder> result = ProtectedTasksCopier.copyToBuilder(this.protectedTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtectedTasks(Collection<ProtectedTask.BuilderImpl> protectedTasks) {
            this.protectedTasks = ProtectedTasksCopier.copyFromBuilder(protectedTasks);
        }

        @Override
        public final Builder protectedTasks(Collection<ProtectedTask> protectedTasks) {
            this.protectedTasks = ProtectedTasksCopier.copy(protectedTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedTasks(ProtectedTask ... protectedTasks) {
            this.protectedTasks(Arrays.asList(protectedTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedTasks(Consumer<ProtectedTask.Builder> ... protectedTasks) {
            this.protectedTasks(Stream.of(protectedTasks).map(c -> (ProtectedTask)((ProtectedTask.Builder)ProtectedTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Failure.Builder> getFailures() {
            List<Failure.Builder> result = FailuresCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<Failure.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<Failure> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (Failure)((Failure.Builder)Failure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetTaskProtectionResponse build() {
            return new GetTaskProtectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTaskProtectionResponse> {
        public Builder protectedTasks(Collection<ProtectedTask> var1);

        public Builder protectedTasks(ProtectedTask ... var1);

        public Builder protectedTasks(Consumer<ProtectedTask.Builder> ... var1);

        public Builder failures(Collection<Failure> var1);

        public Builder failures(Failure ... var1);

        public Builder failures(Consumer<Failure.Builder> ... var1);
    }
}

