/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CVSS score for a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CvssScore implements SdkPojo, Serializable, ToCopyableBuilder<CvssScore.Builder, CvssScore> {
    private static final SdkField<Double> BASE_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("baseScore").getter(getter(CvssScore::baseScore)).setter(setter(Builder::baseScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseScore").build()).build();

    private static final SdkField<String> SCORING_VECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scoringVector").getter(getter(CvssScore::scoringVector)).setter(setter(Builder::scoringVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoringVector").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(CvssScore::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(CvssScore::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_SCORE_FIELD,
            SCORING_VECTOR_FIELD, SOURCE_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double baseScore;

    private final String scoringVector;

    private final String source;

    private final String version;

    private CvssScore(BuilderImpl builder) {
        this.baseScore = builder.baseScore;
        this.scoringVector = builder.scoringVector;
        this.source = builder.source;
        this.version = builder.version;
    }

    /**
     * <p>
     * The base CVSS score used for the finding.
     * </p>
     * 
     * @return The base CVSS score used for the finding.
     */
    public final Double baseScore() {
        return baseScore;
    }

    /**
     * <p>
     * The vector string of the CVSS score.
     * </p>
     * 
     * @return The vector string of the CVSS score.
     */
    public final String scoringVector() {
        return scoringVector;
    }

    /**
     * <p>
     * The source of the CVSS score.
     * </p>
     * 
     * @return The source of the CVSS score.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The version of CVSS used for the score.
     * </p>
     * 
     * @return The version of CVSS used for the score.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseScore());
        hashCode = 31 * hashCode + Objects.hashCode(scoringVector());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CvssScore)) {
            return false;
        }
        CvssScore other = (CvssScore) obj;
        return Objects.equals(baseScore(), other.baseScore()) && Objects.equals(scoringVector(), other.scoringVector())
                && Objects.equals(source(), other.source()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CvssScore").add("BaseScore", baseScore()).add("ScoringVector", scoringVector())
                .add("Source", source()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "baseScore":
            return Optional.ofNullable(clazz.cast(baseScore()));
        case "scoringVector":
            return Optional.ofNullable(clazz.cast(scoringVector()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CvssScore, T> g) {
        return obj -> g.apply((CvssScore) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CvssScore> {
        /**
         * <p>
         * The base CVSS score used for the finding.
         * </p>
         * 
         * @param baseScore
         *        The base CVSS score used for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseScore(Double baseScore);

        /**
         * <p>
         * The vector string of the CVSS score.
         * </p>
         * 
         * @param scoringVector
         *        The vector string of the CVSS score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoringVector(String scoringVector);

        /**
         * <p>
         * The source of the CVSS score.
         * </p>
         * 
         * @param source
         *        The source of the CVSS score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The version of CVSS used for the score.
         * </p>
         * 
         * @param version
         *        The version of CVSS used for the score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private Double baseScore;

        private String scoringVector;

        private String source;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(CvssScore model) {
            baseScore(model.baseScore);
            scoringVector(model.scoringVector);
            source(model.source);
            version(model.version);
        }

        public final Double getBaseScore() {
            return baseScore;
        }

        public final void setBaseScore(Double baseScore) {
            this.baseScore = baseScore;
        }

        @Override
        public final Builder baseScore(Double baseScore) {
            this.baseScore = baseScore;
            return this;
        }

        public final String getScoringVector() {
            return scoringVector;
        }

        public final void setScoringVector(String scoringVector) {
            this.scoringVector = scoringVector;
        }

        @Override
        public final Builder scoringVector(String scoringVector) {
            this.scoringVector = scoringVector;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public CvssScore build() {
            return new CvssScore(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
