/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImageScanRequest extends EcrRequest implements
        ToCopyableBuilder<StartImageScanRequest.Builder, StartImageScanRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(StartImageScanRequest::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(StartImageScanRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<ImageIdentifier> IMAGE_ID_FIELD = SdkField.<ImageIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("imageId").getter(getter(StartImageScanRequest::imageId)).setter(setter(Builder::imageId))
            .constructor(ImageIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, IMAGE_ID_FIELD));

    private final String registryId;

    private final String repositoryName;

    private final ImageIdentifier imageId;

    private StartImageScanRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry that contains the repository in which to start an
     * image scan request. If you do not specify a registry, the default registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry that contains the repository in which to
     *         start an image scan request. If you do not specify a registry, the default registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository that contains the images to scan.
     * </p>
     * 
     * @return The name of the repository that contains the images to scan.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * Returns the value of the ImageId property for this object.
     * 
     * @return The value of the ImageId property for this object.
     */
    public final ImageIdentifier imageId() {
        return imageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImageScanRequest)) {
            return false;
        }
        StartImageScanRequest other = (StartImageScanRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(imageId(), other.imageId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartImageScanRequest").add("RegistryId", registryId()).add("RepositoryName", repositoryName())
                .add("ImageId", imageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "imageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartImageScanRequest, T> g) {
        return obj -> g.apply((StartImageScanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartImageScanRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry that contains the repository in which to
         * start an image scan request. If you do not specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry that contains the repository in which
         *        to start an image scan request. If you do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository that contains the images to scan.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the images to scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * Sets the value of the ImageId property for this object.
         *
         * @param imageId
         *        The new value for the ImageId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(ImageIdentifier imageId);

        /**
         * Sets the value of the ImageId property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ImageIdentifier.Builder} avoiding the
         * need to create one manually via {@link ImageIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #imageId(ImageIdentifier)}.
         * 
         * @param imageId
         *        a consumer that will call methods on {@link ImageIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageId(ImageIdentifier)
         */
        default Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return imageId(ImageIdentifier.builder().applyMutation(imageId).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private ImageIdentifier imageId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImageScanRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            imageId(model.imageId);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final ImageIdentifier.Builder getImageId() {
            return imageId != null ? imageId.toBuilder() : null;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImageScanRequest build() {
            return new StartImageScanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
