/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the lifecycle policy preview request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicyPreviewSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecyclePolicyPreviewSummary.Builder, LifecyclePolicyPreviewSummary> {
    private static final SdkField<Integer> EXPIRING_IMAGE_TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("expiringImageTotalCount").getter(getter(LifecyclePolicyPreviewSummary::expiringImageTotalCount))
            .setter(setter(Builder::expiringImageTotalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiringImageTotalCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EXPIRING_IMAGE_TOTAL_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer expiringImageTotalCount;

    private LifecyclePolicyPreviewSummary(BuilderImpl builder) {
        this.expiringImageTotalCount = builder.expiringImageTotalCount;
    }

    /**
     * <p>
     * The number of expiring images.
     * </p>
     * 
     * @return The number of expiring images.
     */
    public final Integer expiringImageTotalCount() {
        return expiringImageTotalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expiringImageTotalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyPreviewSummary)) {
            return false;
        }
        LifecyclePolicyPreviewSummary other = (LifecyclePolicyPreviewSummary) obj;
        return Objects.equals(expiringImageTotalCount(), other.expiringImageTotalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecyclePolicyPreviewSummary").add("ExpiringImageTotalCount", expiringImageTotalCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "expiringImageTotalCount":
            return Optional.ofNullable(clazz.cast(expiringImageTotalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyPreviewSummary, T> g) {
        return obj -> g.apply((LifecyclePolicyPreviewSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicyPreviewSummary> {
        /**
         * <p>
         * The number of expiring images.
         * </p>
         * 
         * @param expiringImageTotalCount
         *        The number of expiring images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiringImageTotalCount(Integer expiringImageTotalCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer expiringImageTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyPreviewSummary model) {
            expiringImageTotalCount(model.expiringImageTotalCount);
        }

        public final Integer getExpiringImageTotalCount() {
            return expiringImageTotalCount;
        }

        public final void setExpiringImageTotalCount(Integer expiringImageTotalCount) {
            this.expiringImageTotalCount = expiringImageTotalCount;
        }

        @Override
        public final Builder expiringImageTotalCount(Integer expiringImageTotalCount) {
            this.expiringImageTotalCount = expiringImageTotalCount;
            return this;
        }

        @Override
        public LifecyclePolicyPreviewSummary build() {
            return new LifecyclePolicyPreviewSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
