/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2instanceconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendSshPublicKeyRequest extends Ec2InstanceConnectRequest implements
        ToCopyableBuilder<SendSshPublicKeyRequest.Builder, SendSshPublicKeyRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(SendSshPublicKeyRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> INSTANCE_OS_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceOSUser").getter(getter(SendSshPublicKeyRequest::instanceOSUser))
            .setter(setter(Builder::instanceOSUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceOSUser").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SSHPublicKey").getter(getter(SendSshPublicKeyRequest::sshPublicKey))
            .setter(setter(Builder::sshPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSHPublicKey").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(SendSshPublicKeyRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            INSTANCE_OS_USER_FIELD, SSH_PUBLIC_KEY_FIELD, AVAILABILITY_ZONE_FIELD));

    private final String instanceId;

    private final String instanceOSUser;

    private final String sshPublicKey;

    private final String availabilityZone;

    private SendSshPublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.instanceOSUser = builder.instanceOSUser;
        this.sshPublicKey = builder.sshPublicKey;
        this.availabilityZone = builder.availabilityZone;
    }

    /**
     * <p>
     * The ID of the EC2 instance.
     * </p>
     * 
     * @return The ID of the EC2 instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The OS user on the EC2 instance for whom the key can be used to authenticate.
     * </p>
     * 
     * @return The OS user on the EC2 instance for whom the key can be used to authenticate.
     */
    public final String instanceOSUser() {
        return instanceOSUser;
    }

    /**
     * <p>
     * The public key material. To use the public key, you must have the matching private key.
     * </p>
     * 
     * @return The public key material. To use the public key, you must have the matching private key.
     */
    public final String sshPublicKey() {
        return sshPublicKey;
    }

    /**
     * <p>
     * The Availability Zone in which the EC2 instance was launched.
     * </p>
     * 
     * @return The Availability Zone in which the EC2 instance was launched.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceOSUser());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendSshPublicKeyRequest)) {
            return false;
        }
        SendSshPublicKeyRequest other = (SendSshPublicKeyRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(instanceOSUser(), other.instanceOSUser())
                && Objects.equals(sshPublicKey(), other.sshPublicKey())
                && Objects.equals(availabilityZone(), other.availabilityZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendSshPublicKeyRequest").add("InstanceId", instanceId())
                .add("InstanceOSUser", instanceOSUser()).add("SSHPublicKey", sshPublicKey())
                .add("AvailabilityZone", availabilityZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceOSUser":
            return Optional.ofNullable(clazz.cast(instanceOSUser()));
        case "SSHPublicKey":
            return Optional.ofNullable(clazz.cast(sshPublicKey()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendSshPublicKeyRequest, T> g) {
        return obj -> g.apply((SendSshPublicKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2InstanceConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SendSshPublicKeyRequest> {
        /**
         * <p>
         * The ID of the EC2 instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The OS user on the EC2 instance for whom the key can be used to authenticate.
         * </p>
         * 
         * @param instanceOSUser
         *        The OS user on the EC2 instance for whom the key can be used to authenticate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceOSUser(String instanceOSUser);

        /**
         * <p>
         * The public key material. To use the public key, you must have the matching private key.
         * </p>
         * 
         * @param sshPublicKey
         *        The public key material. To use the public key, you must have the matching private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKey(String sshPublicKey);

        /**
         * <p>
         * The Availability Zone in which the EC2 instance was launched.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the EC2 instance was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2InstanceConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String instanceOSUser;

        private String sshPublicKey;

        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(SendSshPublicKeyRequest model) {
            super(model);
            instanceId(model.instanceId);
            instanceOSUser(model.instanceOSUser);
            sshPublicKey(model.sshPublicKey);
            availabilityZone(model.availabilityZone);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceOSUser() {
            return instanceOSUser;
        }

        public final void setInstanceOSUser(String instanceOSUser) {
            this.instanceOSUser = instanceOSUser;
        }

        @Override
        public final Builder instanceOSUser(String instanceOSUser) {
            this.instanceOSUser = instanceOSUser;
            return this;
        }

        public final String getSshPublicKey() {
            return sshPublicKey;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendSshPublicKeyRequest build() {
            return new SendSshPublicKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
