/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceEventWindowResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyInstanceEventWindowResponse.Builder, ModifyInstanceEventWindowResponse> {
    private static final SdkField<InstanceEventWindow> INSTANCE_EVENT_WINDOW_FIELD = SdkField
            .<InstanceEventWindow> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceEventWindow")
            .getter(getter(ModifyInstanceEventWindowResponse::instanceEventWindow))
            .setter(setter(Builder::instanceEventWindow))
            .constructor(InstanceEventWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventWindow")
                    .unmarshallLocationName("instanceEventWindow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_EVENT_WINDOW_FIELD));

    private final InstanceEventWindow instanceEventWindow;

    private ModifyInstanceEventWindowResponse(BuilderImpl builder) {
        super(builder);
        this.instanceEventWindow = builder.instanceEventWindow;
    }

    /**
     * <p>
     * Information about the event window.
     * </p>
     * 
     * @return Information about the event window.
     */
    public final InstanceEventWindow instanceEventWindow() {
        return instanceEventWindow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceEventWindow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceEventWindowResponse)) {
            return false;
        }
        ModifyInstanceEventWindowResponse other = (ModifyInstanceEventWindowResponse) obj;
        return Objects.equals(instanceEventWindow(), other.instanceEventWindow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstanceEventWindowResponse").add("InstanceEventWindow", instanceEventWindow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceEventWindow":
            return Optional.ofNullable(clazz.cast(instanceEventWindow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceEventWindowResponse, T> g) {
        return obj -> g.apply((ModifyInstanceEventWindowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ModifyInstanceEventWindowResponse> {
        /**
         * <p>
         * Information about the event window.
         * </p>
         * 
         * @param instanceEventWindow
         *        Information about the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceEventWindow(InstanceEventWindow instanceEventWindow);

        /**
         * <p>
         * Information about the event window.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceEventWindow.Builder} avoiding the
         * need to create one manually via {@link InstanceEventWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceEventWindow.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceEventWindow(InstanceEventWindow)}.
         * 
         * @param instanceEventWindow
         *        a consumer that will call methods on {@link InstanceEventWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceEventWindow(InstanceEventWindow)
         */
        default Builder instanceEventWindow(Consumer<InstanceEventWindow.Builder> instanceEventWindow) {
            return instanceEventWindow(InstanceEventWindow.builder().applyMutation(instanceEventWindow).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private InstanceEventWindow instanceEventWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceEventWindowResponse model) {
            super(model);
            instanceEventWindow(model.instanceEventWindow);
        }

        public final InstanceEventWindow.Builder getInstanceEventWindow() {
            return instanceEventWindow != null ? instanceEventWindow.toBuilder() : null;
        }

        public final void setInstanceEventWindow(InstanceEventWindow.BuilderImpl instanceEventWindow) {
            this.instanceEventWindow = instanceEventWindow != null ? instanceEventWindow.build() : null;
        }

        @Override
        public final Builder instanceEventWindow(InstanceEventWindow instanceEventWindow) {
            this.instanceEventWindow = instanceEventWindow;
            return this;
        }

        @Override
        public ModifyInstanceEventWindowResponse build() {
            return new ModifyInstanceEventWindowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
