/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a disk.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiskInfo implements SdkPojo, Serializable, ToCopyableBuilder<DiskInfo.Builder, DiskInfo> {
    private static final SdkField<Long> SIZE_IN_GB_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("SizeInGB")
            .getter(getter(DiskInfo::sizeInGB))
            .setter(setter(Builder::sizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInGB")
                    .unmarshallLocationName("sizeInGB").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Count")
            .getter(getter(DiskInfo::count))
            .setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count")
                    .unmarshallLocationName("count").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(DiskInfo::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_IN_GB_FIELD, COUNT_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long sizeInGB;

    private final Integer count;

    private final String type;

    private DiskInfo(BuilderImpl builder) {
        this.sizeInGB = builder.sizeInGB;
        this.count = builder.count;
        this.type = builder.type;
    }

    /**
     * <p>
     * The size of the disk in GB.
     * </p>
     * 
     * @return The size of the disk in GB.
     */
    public final Long sizeInGB() {
        return sizeInGB;
    }

    /**
     * <p>
     * The number of disks with this configuration.
     * </p>
     * 
     * @return The number of disks with this configuration.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The type of disk.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DiskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of disk.
     * @see DiskType
     */
    public final DiskType type() {
        return DiskType.fromValue(type);
    }

    /**
     * <p>
     * The type of disk.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DiskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of disk.
     * @see DiskType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskInfo)) {
            return false;
        }
        DiskInfo other = (DiskInfo) obj;
        return Objects.equals(sizeInGB(), other.sizeInGB()) && Objects.equals(count(), other.count())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiskInfo").add("SizeInGB", sizeInGB()).add("Count", count()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SizeInGB":
            return Optional.ofNullable(clazz.cast(sizeInGB()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiskInfo, T> g) {
        return obj -> g.apply((DiskInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DiskInfo> {
        /**
         * <p>
         * The size of the disk in GB.
         * </p>
         * 
         * @param sizeInGB
         *        The size of the disk in GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGB(Long sizeInGB);

        /**
         * <p>
         * The number of disks with this configuration.
         * </p>
         * 
         * @param count
         *        The number of disks with this configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The type of disk.
         * </p>
         * 
         * @param type
         *        The type of disk.
         * @see DiskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of disk.
         * </p>
         * 
         * @param type
         *        The type of disk.
         * @see DiskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskType
         */
        Builder type(DiskType type);
    }

    static final class BuilderImpl implements Builder {
        private Long sizeInGB;

        private Integer count;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskInfo model) {
            sizeInGB(model.sizeInGB);
            count(model.count);
            type(model.type);
        }

        public final Long getSizeInGB() {
            return sizeInGB;
        }

        public final void setSizeInGB(Long sizeInGB) {
            this.sizeInGB = sizeInGB;
        }

        @Override
        public final Builder sizeInGB(Long sizeInGB) {
            this.sizeInGB = sizeInGB;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DiskType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public DiskInfo build() {
            return new DiskInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
