/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeReservedInstancesListings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedInstancesListingsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeReservedInstancesListingsRequest.Builder, DescribeReservedInstancesListingsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeReservedInstancesListingsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedInstancesId")
            .getter(getter(DescribeReservedInstancesListingsRequest::reservedInstancesId))
            .setter(setter(Builder::reservedInstancesId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId")
                    .unmarshallLocationName("reservedInstancesId").build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_LISTING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedInstancesListingId")
            .getter(getter(DescribeReservedInstancesListingsRequest::reservedInstancesListingId))
            .setter(setter(Builder::reservedInstancesListingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesListingId")
                    .unmarshallLocationName("reservedInstancesListingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            RESERVED_INSTANCES_ID_FIELD, RESERVED_INSTANCES_LISTING_ID_FIELD));

    private final List<Filter> filters;

    private final String reservedInstancesId;

    private final String reservedInstancesListingId;

    private DescribeReservedInstancesListingsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>reserved-instances-id</code> - The ID of the Reserved Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> | <code>active</code> |
     * <code>cancelled</code> | <code>closed</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status-message</code> - The reason for the status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>reserved-instances-id</code> - The ID of the Reserved Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> |
     *         <code>active</code> | <code>cancelled</code> | <code>closed</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status-message</code> - The reason for the status.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more Reserved Instance IDs.
     * </p>
     * 
     * @return One or more Reserved Instance IDs.
     */
    public final String reservedInstancesId() {
        return reservedInstancesId;
    }

    /**
     * <p>
     * One or more Reserved Instance listing IDs.
     * </p>
     * 
     * @return One or more Reserved Instance listing IDs.
     */
    public final String reservedInstancesListingId() {
        return reservedInstancesListingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesListingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesListingsRequest)) {
            return false;
        }
        DescribeReservedInstancesListingsRequest other = (DescribeReservedInstancesListingsRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(reservedInstancesId(), other.reservedInstancesId())
                && Objects.equals(reservedInstancesListingId(), other.reservedInstancesListingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReservedInstancesListingsRequest").add("Filters", hasFilters() ? filters() : null)
                .add("ReservedInstancesId", reservedInstancesId())
                .add("ReservedInstancesListingId", reservedInstancesListingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "ReservedInstancesId":
            return Optional.ofNullable(clazz.cast(reservedInstancesId()));
        case "ReservedInstancesListingId":
            return Optional.ofNullable(clazz.cast(reservedInstancesListingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstancesListingsRequest, T> g) {
        return obj -> g.apply((DescribeReservedInstancesListingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedInstancesListingsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>reserved-instances-id</code> - The ID of the Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> | <code>active</code>
         * | <code>cancelled</code> | <code>closed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The reason for the status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>reserved-instances-id</code> - The ID of the Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> |
         *        <code>active</code> | <code>cancelled</code> | <code>closed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - The reason for the status.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>reserved-instances-id</code> - The ID of the Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> | <code>active</code>
         * | <code>cancelled</code> | <code>closed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The reason for the status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>reserved-instances-id</code> - The ID of the Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> |
         *        <code>active</code> | <code>cancelled</code> | <code>closed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - The reason for the status.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>reserved-instances-id</code> - The ID of the Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> | <code>active</code>
         * | <code>cancelled</code> | <code>closed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The reason for the status.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * One or more Reserved Instance IDs.
         * </p>
         * 
         * @param reservedInstancesId
         *        One or more Reserved Instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);

        /**
         * <p>
         * One or more Reserved Instance listing IDs.
         * </p>
         * 
         * @param reservedInstancesListingId
         *        One or more Reserved Instance listing IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListingId(String reservedInstancesListingId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private String reservedInstancesId;

        private String reservedInstancesListingId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesListingsRequest model) {
            super(model);
            filters(model.filters);
            reservedInstancesId(model.reservedInstancesId);
            reservedInstancesListingId(model.reservedInstancesListingId);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final String getReservedInstancesListingId() {
            return reservedInstancesListingId;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        @Override
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedInstancesListingsRequest build() {
            return new DescribeReservedInstancesListingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
