/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointEniOptions;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointAttachmentType;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVerifiedAccessEndpointRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateVerifiedAccessEndpointRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessGroupId").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::verifiedAccessGroupId)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::verifiedAccessGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupId").unmarshallLocationName("VerifiedAccessGroupId").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::endpointTypeAsString)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").unmarshallLocationName("EndpointType").build()}).build();
    private static final SdkField<String> ATTACHMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentType").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::attachmentTypeAsString)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::attachmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentType").unmarshallLocationName("AttachmentType").build()}).build();
    private static final SdkField<String> DOMAIN_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainCertificateArn").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::domainCertificateArn)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::domainCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainCertificateArn").unmarshallLocationName("DomainCertificateArn").build()}).build();
    private static final SdkField<String> APPLICATION_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationDomain").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::applicationDomain)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::applicationDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDomain").unmarshallLocationName("ApplicationDomain").build()}).build();
    private static final SdkField<String> ENDPOINT_DOMAIN_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointDomainPrefix").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::endpointDomainPrefix)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::endpointDomainPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDomainPrefix").unmarshallLocationName("EndpointDomainPrefix").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::securityGroupIds)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<CreateVerifiedAccessEndpointLoadBalancerOptions> LOAD_BALANCER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoadBalancerOptions").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::loadBalancerOptions)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::loadBalancerOptions)).constructor(CreateVerifiedAccessEndpointLoadBalancerOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerOptions").unmarshallLocationName("LoadBalancerOptions").build()}).build();
    private static final SdkField<CreateVerifiedAccessEndpointEniOptions> NETWORK_INTERFACE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkInterfaceOptions").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::networkInterfaceOptions)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::networkInterfaceOptions)).constructor(CreateVerifiedAccessEndpointEniOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceOptions").unmarshallLocationName("NetworkInterfaceOptions").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::description)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::policyDocument)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").unmarshallLocationName("PolicyDocument").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::tagSpecifications)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::clientToken)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateVerifiedAccessEndpointRequest.getter(CreateVerifiedAccessEndpointRequest::dryRun)).setter(CreateVerifiedAccessEndpointRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_GROUP_ID_FIELD, ENDPOINT_TYPE_FIELD, ATTACHMENT_TYPE_FIELD, DOMAIN_CERTIFICATE_ARN_FIELD, APPLICATION_DOMAIN_FIELD, ENDPOINT_DOMAIN_PREFIX_FIELD, SECURITY_GROUP_IDS_FIELD, LOAD_BALANCER_OPTIONS_FIELD, NETWORK_INTERFACE_OPTIONS_FIELD, DESCRIPTION_FIELD, POLICY_DOCUMENT_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD));
    private final String verifiedAccessGroupId;
    private final String endpointType;
    private final String attachmentType;
    private final String domainCertificateArn;
    private final String applicationDomain;
    private final String endpointDomainPrefix;
    private final List<String> securityGroupIds;
    private final CreateVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions;
    private final CreateVerifiedAccessEndpointEniOptions networkInterfaceOptions;
    private final String description;
    private final String policyDocument;
    private final List<TagSpecification> tagSpecifications;
    private final String clientToken;
    private final Boolean dryRun;

    private CreateVerifiedAccessEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessGroupId = builder.verifiedAccessGroupId;
        this.endpointType = builder.endpointType;
        this.attachmentType = builder.attachmentType;
        this.domainCertificateArn = builder.domainCertificateArn;
        this.applicationDomain = builder.applicationDomain;
        this.endpointDomainPrefix = builder.endpointDomainPrefix;
        this.securityGroupIds = builder.securityGroupIds;
        this.loadBalancerOptions = builder.loadBalancerOptions;
        this.networkInterfaceOptions = builder.networkInterfaceOptions;
        this.description = builder.description;
        this.policyDocument = builder.policyDocument;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
    }

    public final String verifiedAccessGroupId() {
        return this.verifiedAccessGroupId;
    }

    public final VerifiedAccessEndpointType endpointType() {
        return VerifiedAccessEndpointType.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    public final VerifiedAccessEndpointAttachmentType attachmentType() {
        return VerifiedAccessEndpointAttachmentType.fromValue(this.attachmentType);
    }

    public final String attachmentTypeAsString() {
        return this.attachmentType;
    }

    public final String domainCertificateArn() {
        return this.domainCertificateArn;
    }

    public final String applicationDomain() {
        return this.applicationDomain;
    }

    public final String endpointDomainPrefix() {
        return this.endpointDomainPrefix;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final CreateVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions() {
        return this.loadBalancerOptions;
    }

    public final CreateVerifiedAccessEndpointEniOptions networkInterfaceOptions() {
        return this.networkInterfaceOptions;
    }

    public final String description() {
        return this.description;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointDomainPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVerifiedAccessEndpointRequest)) {
            return false;
        }
        CreateVerifiedAccessEndpointRequest other = (CreateVerifiedAccessEndpointRequest)((Object)obj);
        return Objects.equals(this.verifiedAccessGroupId(), other.verifiedAccessGroupId()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.attachmentTypeAsString(), other.attachmentTypeAsString()) && Objects.equals(this.domainCertificateArn(), other.domainCertificateArn()) && Objects.equals(this.applicationDomain(), other.applicationDomain()) && Objects.equals(this.endpointDomainPrefix(), other.endpointDomainPrefix()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.loadBalancerOptions(), other.loadBalancerOptions()) && Objects.equals(this.networkInterfaceOptions(), other.networkInterfaceOptions()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.policyDocument(), other.policyDocument()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVerifiedAccessEndpointRequest").add("VerifiedAccessGroupId", (Object)this.verifiedAccessGroupId()).add("EndpointType", (Object)this.endpointTypeAsString()).add("AttachmentType", (Object)this.attachmentTypeAsString()).add("DomainCertificateArn", (Object)this.domainCertificateArn()).add("ApplicationDomain", (Object)this.applicationDomain()).add("EndpointDomainPrefix", (Object)this.endpointDomainPrefix()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("LoadBalancerOptions", (Object)this.loadBalancerOptions()).add("NetworkInterfaceOptions", (Object)this.networkInterfaceOptions()).add("Description", (Object)this.description()).add("PolicyDocument", (Object)this.policyDocument()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessGroupId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessGroupId()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "AttachmentType": {
                return Optional.ofNullable(clazz.cast(this.attachmentTypeAsString()));
            }
            case "DomainCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.domainCertificateArn()));
            }
            case "ApplicationDomain": {
                return Optional.ofNullable(clazz.cast(this.applicationDomain()));
            }
            case "EndpointDomainPrefix": {
                return Optional.ofNullable(clazz.cast(this.endpointDomainPrefix()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "LoadBalancerOptions": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerOptions()));
            }
            case "NetworkInterfaceOptions": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceOptions()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVerifiedAccessEndpointRequest, T> g) {
        return obj -> g.apply((CreateVerifiedAccessEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String verifiedAccessGroupId;
        private String endpointType;
        private String attachmentType;
        private String domainCertificateArn;
        private String applicationDomain;
        private String endpointDomainPrefix;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private CreateVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions;
        private CreateVerifiedAccessEndpointEniOptions networkInterfaceOptions;
        private String description;
        private String policyDocument;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVerifiedAccessEndpointRequest model) {
            super(model);
            this.verifiedAccessGroupId(model.verifiedAccessGroupId);
            this.endpointType(model.endpointType);
            this.attachmentType(model.attachmentType);
            this.domainCertificateArn(model.domainCertificateArn);
            this.applicationDomain(model.applicationDomain);
            this.endpointDomainPrefix(model.endpointDomainPrefix);
            this.securityGroupIds(model.securityGroupIds);
            this.loadBalancerOptions(model.loadBalancerOptions);
            this.networkInterfaceOptions(model.networkInterfaceOptions);
            this.description(model.description);
            this.policyDocument(model.policyDocument);
            this.tagSpecifications(model.tagSpecifications);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
        }

        public final String getVerifiedAccessGroupId() {
            return this.verifiedAccessGroupId;
        }

        public final void setVerifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
        }

        @Override
        public final Builder verifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(VerifiedAccessEndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getAttachmentType() {
            return this.attachmentType;
        }

        public final void setAttachmentType(String attachmentType) {
            this.attachmentType = attachmentType;
        }

        @Override
        public final Builder attachmentType(String attachmentType) {
            this.attachmentType = attachmentType;
            return this;
        }

        @Override
        public final Builder attachmentType(VerifiedAccessEndpointAttachmentType attachmentType) {
            this.attachmentType(attachmentType == null ? null : attachmentType.toString());
            return this;
        }

        public final String getDomainCertificateArn() {
            return this.domainCertificateArn;
        }

        public final void setDomainCertificateArn(String domainCertificateArn) {
            this.domainCertificateArn = domainCertificateArn;
        }

        @Override
        public final Builder domainCertificateArn(String domainCertificateArn) {
            this.domainCertificateArn = domainCertificateArn;
            return this;
        }

        public final String getApplicationDomain() {
            return this.applicationDomain;
        }

        public final void setApplicationDomain(String applicationDomain) {
            this.applicationDomain = applicationDomain;
        }

        @Override
        public final Builder applicationDomain(String applicationDomain) {
            this.applicationDomain = applicationDomain;
            return this;
        }

        public final String getEndpointDomainPrefix() {
            return this.endpointDomainPrefix;
        }

        public final void setEndpointDomainPrefix(String endpointDomainPrefix) {
            this.endpointDomainPrefix = endpointDomainPrefix;
        }

        @Override
        public final Builder endpointDomainPrefix(String endpointDomainPrefix) {
            this.endpointDomainPrefix = endpointDomainPrefix;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final CreateVerifiedAccessEndpointLoadBalancerOptions.Builder getLoadBalancerOptions() {
            return this.loadBalancerOptions != null ? this.loadBalancerOptions.toBuilder() : null;
        }

        public final void setLoadBalancerOptions(CreateVerifiedAccessEndpointLoadBalancerOptions.BuilderImpl loadBalancerOptions) {
            this.loadBalancerOptions = loadBalancerOptions != null ? loadBalancerOptions.build() : null;
        }

        @Override
        public final Builder loadBalancerOptions(CreateVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions) {
            this.loadBalancerOptions = loadBalancerOptions;
            return this;
        }

        public final CreateVerifiedAccessEndpointEniOptions.Builder getNetworkInterfaceOptions() {
            return this.networkInterfaceOptions != null ? this.networkInterfaceOptions.toBuilder() : null;
        }

        public final void setNetworkInterfaceOptions(CreateVerifiedAccessEndpointEniOptions.BuilderImpl networkInterfaceOptions) {
            this.networkInterfaceOptions = networkInterfaceOptions != null ? networkInterfaceOptions.build() : null;
        }

        @Override
        public final Builder networkInterfaceOptions(CreateVerifiedAccessEndpointEniOptions networkInterfaceOptions) {
            this.networkInterfaceOptions = networkInterfaceOptions;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVerifiedAccessEndpointRequest build() {
            return new CreateVerifiedAccessEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVerifiedAccessEndpointRequest> {
        public Builder verifiedAccessGroupId(String var1);

        public Builder endpointType(String var1);

        public Builder endpointType(VerifiedAccessEndpointType var1);

        public Builder attachmentType(String var1);

        public Builder attachmentType(VerifiedAccessEndpointAttachmentType var1);

        public Builder domainCertificateArn(String var1);

        public Builder applicationDomain(String var1);

        public Builder endpointDomainPrefix(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder loadBalancerOptions(CreateVerifiedAccessEndpointLoadBalancerOptions var1);

        default public Builder loadBalancerOptions(Consumer<CreateVerifiedAccessEndpointLoadBalancerOptions.Builder> loadBalancerOptions) {
            return this.loadBalancerOptions((CreateVerifiedAccessEndpointLoadBalancerOptions)((CreateVerifiedAccessEndpointLoadBalancerOptions.Builder)CreateVerifiedAccessEndpointLoadBalancerOptions.builder().applyMutation(loadBalancerOptions)).build());
        }

        public Builder networkInterfaceOptions(CreateVerifiedAccessEndpointEniOptions var1);

        default public Builder networkInterfaceOptions(Consumer<CreateVerifiedAccessEndpointEniOptions.Builder> networkInterfaceOptions) {
            return this.networkInterfaceOptions((CreateVerifiedAccessEndpointEniOptions)((CreateVerifiedAccessEndpointEniOptions.Builder)CreateVerifiedAccessEndpointEniOptions.builder().applyMutation(networkInterfaceOptions)).build());
        }

        public Builder description(String var1);

        public Builder policyDocument(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

