/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse;
import software.amazon.awssdk.services.ec2.model.IpamResourceCidr;

public class GetIpamResourceCidrsIterable
implements SdkIterable<GetIpamResourceCidrsResponse> {
    private final Ec2Client client;
    private final GetIpamResourceCidrsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetIpamResourceCidrsIterable(Ec2Client client, GetIpamResourceCidrsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetIpamResourceCidrsResponseFetcher();
    }

    public Iterator<GetIpamResourceCidrsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamResourceCidr> ipamResourceCidrs() {
        Function<GetIpamResourceCidrsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamResourceCidrs() != null) {
                return response.ipamResourceCidrs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetIpamResourceCidrsResponseFetcher
    implements SyncPageFetcher<GetIpamResourceCidrsResponse> {
        private GetIpamResourceCidrsResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamResourceCidrsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetIpamResourceCidrsResponse nextPage(GetIpamResourceCidrsResponse previousPage) {
            if (previousPage == null) {
                return GetIpamResourceCidrsIterable.this.client.getIpamResourceCidrs(GetIpamResourceCidrsIterable.this.firstRequest);
            }
            return GetIpamResourceCidrsIterable.this.client.getIpamResourceCidrs((GetIpamResourceCidrsRequest)((Object)GetIpamResourceCidrsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

