/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachment;

public class DescribeTransitGatewayAttachmentsPublisher
implements SdkPublisher<DescribeTransitGatewayAttachmentsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeTransitGatewayAttachmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTransitGatewayAttachmentsPublisher(Ec2AsyncClient client, DescribeTransitGatewayAttachmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTransitGatewayAttachmentsPublisher(Ec2AsyncClient client, DescribeTransitGatewayAttachmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTransitGatewayAttachmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTransitGatewayAttachmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransitGatewayAttachment> transitGatewayAttachments() {
        Function<DescribeTransitGatewayAttachmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayAttachments() != null) {
                return response.transitGatewayAttachments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTransitGatewayAttachmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTransitGatewayAttachmentsResponseFetcher
    implements AsyncPageFetcher<DescribeTransitGatewayAttachmentsResponse> {
        private DescribeTransitGatewayAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTransitGatewayAttachmentsResponse> nextPage(DescribeTransitGatewayAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayAttachmentsPublisher.this.client.describeTransitGatewayAttachments(DescribeTransitGatewayAttachmentsPublisher.this.firstRequest);
            }
            return DescribeTransitGatewayAttachmentsPublisher.this.client.describeTransitGatewayAttachments((DescribeTransitGatewayAttachmentsRequest)((Object)DescribeTransitGatewayAttachmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

