/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfig;

public class DescribeSpotFleetRequestsIterable
implements SdkIterable<DescribeSpotFleetRequestsResponse> {
    private final Ec2Client client;
    private final DescribeSpotFleetRequestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSpotFleetRequestsIterable(Ec2Client client, DescribeSpotFleetRequestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSpotFleetRequestsResponseFetcher();
    }

    public Iterator<DescribeSpotFleetRequestsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SpotFleetRequestConfig> spotFleetRequestConfigs() {
        Function<DescribeSpotFleetRequestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.spotFleetRequestConfigs() != null) {
                return response.spotFleetRequestConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSpotFleetRequestsResponseFetcher
    implements SyncPageFetcher<DescribeSpotFleetRequestsResponse> {
        private DescribeSpotFleetRequestsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSpotFleetRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSpotFleetRequestsResponse nextPage(DescribeSpotFleetRequestsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSpotFleetRequestsIterable.this.client.describeSpotFleetRequests(DescribeSpotFleetRequestsIterable.this.firstRequest);
            }
            return DescribeSpotFleetRequestsIterable.this.client.describeSpotFleetRequests((DescribeSpotFleetRequestsRequest)((Object)DescribeSpotFleetRequestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

