/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusResponse;
import software.amazon.awssdk.services.ec2.model.SnapshotTierStatus;

public class DescribeSnapshotTierStatusPublisher
implements SdkPublisher<DescribeSnapshotTierStatusResponse> {
    private final Ec2AsyncClient client;
    private final DescribeSnapshotTierStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSnapshotTierStatusPublisher(Ec2AsyncClient client, DescribeSnapshotTierStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSnapshotTierStatusPublisher(Ec2AsyncClient client, DescribeSnapshotTierStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSnapshotTierStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSnapshotTierStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SnapshotTierStatus> snapshotTierStatuses() {
        Function<DescribeSnapshotTierStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshotTierStatuses() != null) {
                return response.snapshotTierStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSnapshotTierStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSnapshotTierStatusResponseFetcher
    implements AsyncPageFetcher<DescribeSnapshotTierStatusResponse> {
        private DescribeSnapshotTierStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSnapshotTierStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSnapshotTierStatusResponse> nextPage(DescribeSnapshotTierStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeSnapshotTierStatusPublisher.this.client.describeSnapshotTierStatus(DescribeSnapshotTierStatusPublisher.this.firstRequest);
            }
            return DescribeSnapshotTierStatusPublisher.this.client.describeSnapshotTierStatus((DescribeSnapshotTierStatusRequest)((Object)DescribeSnapshotTierStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

