/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePermission;

public class DescribeNetworkInterfacePermissionsPublisher
implements SdkPublisher<DescribeNetworkInterfacePermissionsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeNetworkInterfacePermissionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeNetworkInterfacePermissionsPublisher(Ec2AsyncClient client, DescribeNetworkInterfacePermissionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeNetworkInterfacePermissionsPublisher(Ec2AsyncClient client, DescribeNetworkInterfacePermissionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeNetworkInterfacePermissionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeNetworkInterfacePermissionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NetworkInterfacePermission> networkInterfacePermissions() {
        Function<DescribeNetworkInterfacePermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkInterfacePermissions() != null) {
                return response.networkInterfacePermissions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeNetworkInterfacePermissionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeNetworkInterfacePermissionsResponseFetcher
    implements AsyncPageFetcher<DescribeNetworkInterfacePermissionsResponse> {
        private DescribeNetworkInterfacePermissionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNetworkInterfacePermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeNetworkInterfacePermissionsResponse> nextPage(DescribeNetworkInterfacePermissionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNetworkInterfacePermissionsPublisher.this.client.describeNetworkInterfacePermissions(DescribeNetworkInterfacePermissionsPublisher.this.firstRequest);
            }
            return DescribeNetworkInterfacePermissionsPublisher.this.client.describeNetworkInterfacePermissions((DescribeNetworkInterfacePermissionsRequest)((Object)DescribeNetworkInterfacePermissionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

