/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoreSuccessItem;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse;

public class DescribeFastSnapshotRestoresPublisher
implements SdkPublisher<DescribeFastSnapshotRestoresResponse> {
    private final Ec2AsyncClient client;
    private final DescribeFastSnapshotRestoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFastSnapshotRestoresPublisher(Ec2AsyncClient client, DescribeFastSnapshotRestoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFastSnapshotRestoresPublisher(Ec2AsyncClient client, DescribeFastSnapshotRestoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFastSnapshotRestoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFastSnapshotRestoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DescribeFastSnapshotRestoreSuccessItem> fastSnapshotRestores() {
        Function<DescribeFastSnapshotRestoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.fastSnapshotRestores() != null) {
                return response.fastSnapshotRestores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeFastSnapshotRestoresResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeFastSnapshotRestoresResponseFetcher
    implements AsyncPageFetcher<DescribeFastSnapshotRestoresResponse> {
        private DescribeFastSnapshotRestoresResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFastSnapshotRestoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFastSnapshotRestoresResponse> nextPage(DescribeFastSnapshotRestoresResponse previousPage) {
            if (previousPage == null) {
                return DescribeFastSnapshotRestoresPublisher.this.client.describeFastSnapshotRestores(DescribeFastSnapshotRestoresPublisher.this.firstRequest);
            }
            return DescribeFastSnapshotRestoresPublisher.this.client.describeFastSnapshotRestores((DescribeFastSnapshotRestoresRequest)((Object)DescribeFastSnapshotRestoresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

