/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesSuccessItem;

public class DescribeFastLaunchImagesPublisher
implements SdkPublisher<DescribeFastLaunchImagesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeFastLaunchImagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFastLaunchImagesPublisher(Ec2AsyncClient client, DescribeFastLaunchImagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFastLaunchImagesPublisher(Ec2AsyncClient client, DescribeFastLaunchImagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFastLaunchImagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFastLaunchImagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DescribeFastLaunchImagesSuccessItem> fastLaunchImages() {
        Function<DescribeFastLaunchImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.fastLaunchImages() != null) {
                return response.fastLaunchImages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeFastLaunchImagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeFastLaunchImagesResponseFetcher
    implements AsyncPageFetcher<DescribeFastLaunchImagesResponse> {
        private DescribeFastLaunchImagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFastLaunchImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFastLaunchImagesResponse> nextPage(DescribeFastLaunchImagesResponse previousPage) {
            if (previousPage == null) {
                return DescribeFastLaunchImagesPublisher.this.client.describeFastLaunchImages(DescribeFastLaunchImagesPublisher.this.firstRequest);
            }
            return DescribeFastLaunchImagesPublisher.this.client.describeFastLaunchImages((DescribeFastLaunchImagesRequest)((Object)DescribeFastLaunchImagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

