/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.AddressTransfer;
import software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersResponse;

public class DescribeAddressTransfersIterable
implements SdkIterable<DescribeAddressTransfersResponse> {
    private final Ec2Client client;
    private final DescribeAddressTransfersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAddressTransfersIterable(Ec2Client client, DescribeAddressTransfersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAddressTransfersResponseFetcher();
    }

    public Iterator<DescribeAddressTransfersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AddressTransfer> addressTransfers() {
        Function<DescribeAddressTransfersResponse, Iterator> getIterator = response -> {
            if (response != null && response.addressTransfers() != null) {
                return response.addressTransfers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAddressTransfersResponseFetcher
    implements SyncPageFetcher<DescribeAddressTransfersResponse> {
        private DescribeAddressTransfersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAddressTransfersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAddressTransfersResponse nextPage(DescribeAddressTransfersResponse previousPage) {
            if (previousPage == null) {
                return DescribeAddressTransfersIterable.this.client.describeAddressTransfers(DescribeAddressTransfersIterable.this.firstRequest);
            }
            return DescribeAddressTransfersIterable.this.client.describeAddressTransfers((DescribeAddressTransfersRequest)((Object)DescribeAddressTransfersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

