/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceLimitPrice;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseReservedInstancesOfferingRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, PurchaseReservedInstancesOfferingRequest> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(PurchaseReservedInstancesOfferingRequest.getter(PurchaseReservedInstancesOfferingRequest::instanceCount)).setter(PurchaseReservedInstancesOfferingRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("InstanceCount").build()}).build();
    private static final SdkField<String> RESERVED_INSTANCES_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedInstancesOfferingId").getter(PurchaseReservedInstancesOfferingRequest.getter(PurchaseReservedInstancesOfferingRequest::reservedInstancesOfferingId)).setter(PurchaseReservedInstancesOfferingRequest.setter(Builder::reservedInstancesOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesOfferingId").unmarshallLocationName("ReservedInstancesOfferingId").build()}).build();
    private static final SdkField<ReservedInstanceLimitPrice> LIMIT_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LimitPrice").getter(PurchaseReservedInstancesOfferingRequest.getter(PurchaseReservedInstancesOfferingRequest::limitPrice)).setter(PurchaseReservedInstancesOfferingRequest.setter(Builder::limitPrice)).constructor(ReservedInstanceLimitPrice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitPrice").unmarshallLocationName("limitPrice").build()}).build();
    private static final SdkField<Instant> PURCHASE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PurchaseTime").getter(PurchaseReservedInstancesOfferingRequest.getter(PurchaseReservedInstancesOfferingRequest::purchaseTime)).setter(PurchaseReservedInstancesOfferingRequest.setter(Builder::purchaseTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseTime").unmarshallLocationName("PurchaseTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD, RESERVED_INSTANCES_OFFERING_ID_FIELD, LIMIT_PRICE_FIELD, PURCHASE_TIME_FIELD));
    private final Integer instanceCount;
    private final String reservedInstancesOfferingId;
    private final ReservedInstanceLimitPrice limitPrice;
    private final Instant purchaseTime;

    private PurchaseReservedInstancesOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.instanceCount = builder.instanceCount;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.limitPrice = builder.limitPrice;
        this.purchaseTime = builder.purchaseTime;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final String reservedInstancesOfferingId() {
        return this.reservedInstancesOfferingId;
    }

    public final ReservedInstanceLimitPrice limitPrice() {
        return this.limitPrice;
    }

    public final Instant purchaseTime() {
        return this.purchaseTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.limitPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedInstancesOfferingRequest)) {
            return false;
        }
        PurchaseReservedInstancesOfferingRequest other = (PurchaseReservedInstancesOfferingRequest)((Object)obj);
        return Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.reservedInstancesOfferingId(), other.reservedInstancesOfferingId()) && Objects.equals(this.limitPrice(), other.limitPrice()) && Objects.equals(this.purchaseTime(), other.purchaseTime());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseReservedInstancesOfferingRequest").add("InstanceCount", (Object)this.instanceCount()).add("ReservedInstancesOfferingId", (Object)this.reservedInstancesOfferingId()).add("LimitPrice", (Object)this.limitPrice()).add("PurchaseTime", (Object)this.purchaseTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "ReservedInstancesOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesOfferingId()));
            }
            case "LimitPrice": {
                return Optional.ofNullable(clazz.cast(this.limitPrice()));
            }
            case "PurchaseTime": {
                return Optional.ofNullable(clazz.cast(this.purchaseTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedInstancesOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedInstancesOfferingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private String reservedInstancesOfferingId;
        private ReservedInstanceLimitPrice limitPrice;
        private Instant purchaseTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedInstancesOfferingRequest model) {
            super(model);
            this.instanceCount(model.instanceCount);
            this.reservedInstancesOfferingId(model.reservedInstancesOfferingId);
            this.limitPrice(model.limitPrice);
            this.purchaseTime(model.purchaseTime);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getReservedInstancesOfferingId() {
            return this.reservedInstancesOfferingId;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final ReservedInstanceLimitPrice.Builder getLimitPrice() {
            return this.limitPrice != null ? this.limitPrice.toBuilder() : null;
        }

        public final void setLimitPrice(ReservedInstanceLimitPrice.BuilderImpl limitPrice) {
            this.limitPrice = limitPrice != null ? limitPrice.build() : null;
        }

        @Override
        public final Builder limitPrice(ReservedInstanceLimitPrice limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public final Instant getPurchaseTime() {
            return this.purchaseTime;
        }

        public final void setPurchaseTime(Instant purchaseTime) {
            this.purchaseTime = purchaseTime;
        }

        @Override
        public final Builder purchaseTime(Instant purchaseTime) {
            this.purchaseTime = purchaseTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedInstancesOfferingRequest build() {
            return new PurchaseReservedInstancesOfferingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseReservedInstancesOfferingRequest> {
        public Builder instanceCount(Integer var1);

        public Builder reservedInstancesOfferingId(String var1);

        public Builder limitPrice(ReservedInstanceLimitPrice var1);

        default public Builder limitPrice(Consumer<ReservedInstanceLimitPrice.Builder> limitPrice) {
            return this.limitPrice((ReservedInstanceLimitPrice)((ReservedInstanceLimitPrice.Builder)ReservedInstanceLimitPrice.builder().applyMutation(limitPrice)).build());
        }

        public Builder purchaseTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

