/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DedicatedHostIdListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceIdListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceEventWindowAssociationTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceEventWindowAssociationTarget> {
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceIds").getter(InstanceEventWindowAssociationTarget.getter(InstanceEventWindowAssociationTarget::instanceIds)).setter(InstanceEventWindowAssociationTarget.setter(Builder::instanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIdSet").unmarshallLocationName("instanceIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(InstanceEventWindowAssociationTarget.getter(InstanceEventWindowAssociationTarget::tags)).setter(InstanceEventWindowAssociationTarget.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DEDICATED_HOST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DedicatedHostIds").getter(InstanceEventWindowAssociationTarget.getter(InstanceEventWindowAssociationTarget::dedicatedHostIds)).setter(InstanceEventWindowAssociationTarget.setter(Builder::dedicatedHostIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedHostIdSet").unmarshallLocationName("dedicatedHostIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IDS_FIELD, TAGS_FIELD, DEDICATED_HOST_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> instanceIds;
    private final List<Tag> tags;
    private final List<String> dedicatedHostIds;

    private InstanceEventWindowAssociationTarget(BuilderImpl builder) {
        this.instanceIds = builder.instanceIds;
        this.tags = builder.tags;
        this.dedicatedHostIds = builder.dedicatedHostIds;
    }

    public final boolean hasInstanceIds() {
        return this.instanceIds != null && !(this.instanceIds instanceof SdkAutoConstructList);
    }

    public final List<String> instanceIds() {
        return this.instanceIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasDedicatedHostIds() {
        return this.dedicatedHostIds != null && !(this.dedicatedHostIds instanceof SdkAutoConstructList);
    }

    public final List<String> dedicatedHostIds() {
        return this.dedicatedHostIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceIds() ? this.instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDedicatedHostIds() ? this.dedicatedHostIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceEventWindowAssociationTarget)) {
            return false;
        }
        InstanceEventWindowAssociationTarget other = (InstanceEventWindowAssociationTarget)obj;
        return this.hasInstanceIds() == other.hasInstanceIds() && Objects.equals(this.instanceIds(), other.instanceIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasDedicatedHostIds() == other.hasDedicatedHostIds() && Objects.equals(this.dedicatedHostIds(), other.dedicatedHostIds());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceEventWindowAssociationTarget").add("InstanceIds", this.hasInstanceIds() ? this.instanceIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("DedicatedHostIds", this.hasDedicatedHostIds() ? this.dedicatedHostIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DedicatedHostIds": {
                return Optional.ofNullable(clazz.cast(this.dedicatedHostIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceEventWindowAssociationTarget, T> g) {
        return obj -> g.apply((InstanceEventWindowAssociationTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> dedicatedHostIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceEventWindowAssociationTarget model) {
            this.instanceIds(model.instanceIds);
            this.tags(model.tags);
            this.dedicatedHostIds(model.dedicatedHostIds);
        }

        public final Collection<String> getInstanceIds() {
            if (this.instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDedicatedHostIds() {
            if (this.dedicatedHostIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dedicatedHostIds;
        }

        public final void setDedicatedHostIds(Collection<String> dedicatedHostIds) {
            this.dedicatedHostIds = DedicatedHostIdListCopier.copy(dedicatedHostIds);
        }

        @Override
        public final Builder dedicatedHostIds(Collection<String> dedicatedHostIds) {
            this.dedicatedHostIds = DedicatedHostIdListCopier.copy(dedicatedHostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dedicatedHostIds(String ... dedicatedHostIds) {
            this.dedicatedHostIds(Arrays.asList(dedicatedHostIds));
            return this;
        }

        public InstanceEventWindowAssociationTarget build() {
            return new InstanceEventWindowAssociationTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceEventWindowAssociationTarget> {
        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder dedicatedHostIds(Collection<String> var1);

        public Builder dedicatedHostIds(String ... var1);
    }
}

