/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVerifiedAccessEndpointPolicyResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetVerifiedAccessEndpointPolicyResponse> {
    private static final SdkField<Boolean> POLICY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PolicyEnabled").getter(GetVerifiedAccessEndpointPolicyResponse.getter(GetVerifiedAccessEndpointPolicyResponse::policyEnabled)).setter(GetVerifiedAccessEndpointPolicyResponse.setter(Builder::policyEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyEnabled").unmarshallLocationName("policyEnabled").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(GetVerifiedAccessEndpointPolicyResponse.getter(GetVerifiedAccessEndpointPolicyResponse::policyDocument)).setter(GetVerifiedAccessEndpointPolicyResponse.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").unmarshallLocationName("policyDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ENABLED_FIELD, POLICY_DOCUMENT_FIELD));
    private final Boolean policyEnabled;
    private final String policyDocument;

    private GetVerifiedAccessEndpointPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyEnabled = builder.policyEnabled;
        this.policyDocument = builder.policyDocument;
    }

    public final Boolean policyEnabled() {
        return this.policyEnabled;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVerifiedAccessEndpointPolicyResponse)) {
            return false;
        }
        GetVerifiedAccessEndpointPolicyResponse other = (GetVerifiedAccessEndpointPolicyResponse)((Object)obj);
        return Objects.equals(this.policyEnabled(), other.policyEnabled()) && Objects.equals(this.policyDocument(), other.policyDocument());
    }

    public final String toString() {
        return ToString.builder((String)"GetVerifiedAccessEndpointPolicyResponse").add("PolicyEnabled", (Object)this.policyEnabled()).add("PolicyDocument", (Object)this.policyDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyEnabled": {
                return Optional.ofNullable(clazz.cast(this.policyEnabled()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVerifiedAccessEndpointPolicyResponse, T> g) {
        return obj -> g.apply((GetVerifiedAccessEndpointPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Boolean policyEnabled;
        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVerifiedAccessEndpointPolicyResponse model) {
            super(model);
            this.policyEnabled(model.policyEnabled);
            this.policyDocument(model.policyDocument);
        }

        public final Boolean getPolicyEnabled() {
            return this.policyEnabled;
        }

        public final void setPolicyEnabled(Boolean policyEnabled) {
            this.policyEnabled = policyEnabled;
        }

        @Override
        public final Builder policyEnabled(Boolean policyEnabled) {
            this.policyEnabled = policyEnabled;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        @Override
        public GetVerifiedAccessEndpointPolicyResponse build() {
            return new GetVerifiedAccessEndpointPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVerifiedAccessEndpointPolicyResponse> {
        public Builder policyEnabled(Boolean var1);

        public Builder policyDocument(String var1);
    }
}

