/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DhcpConfiguration;
import software.amazon.awssdk.services.ec2.model.DhcpConfigurationListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DhcpOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DhcpOptions> {
    private static final SdkField<List<DhcpConfiguration>> DHCP_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DhcpConfigurations").getter(DhcpOptions.getter(DhcpOptions::dhcpConfigurations)).setter(DhcpOptions.setter(Builder::dhcpConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpConfigurationSet").unmarshallLocationName("dhcpConfigurationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DhcpConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> DHCP_OPTIONS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DhcpOptionsId").getter(DhcpOptions.getter(DhcpOptions::dhcpOptionsId)).setter(DhcpOptions.setter(Builder::dhcpOptionsId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpOptionsId").unmarshallLocationName("dhcpOptionsId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(DhcpOptions.getter(DhcpOptions::ownerId)).setter(DhcpOptions.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DhcpOptions.getter(DhcpOptions::tags)).setter(DhcpOptions.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DHCP_CONFIGURATIONS_FIELD, DHCP_OPTIONS_ID_FIELD, OWNER_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DhcpConfiguration> dhcpConfigurations;
    private final String dhcpOptionsId;
    private final String ownerId;
    private final List<Tag> tags;

    private DhcpOptions(BuilderImpl builder) {
        this.dhcpConfigurations = builder.dhcpConfigurations;
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.ownerId = builder.ownerId;
        this.tags = builder.tags;
    }

    public final boolean hasDhcpConfigurations() {
        return this.dhcpConfigurations != null && !(this.dhcpConfigurations instanceof SdkAutoConstructList);
    }

    public final List<DhcpConfiguration> dhcpConfigurations() {
        return this.dhcpConfigurations;
    }

    public final String dhcpOptionsId() {
        return this.dhcpOptionsId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDhcpConfigurations() ? this.dhcpConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dhcpOptionsId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DhcpOptions)) {
            return false;
        }
        DhcpOptions other = (DhcpOptions)obj;
        return this.hasDhcpConfigurations() == other.hasDhcpConfigurations() && Objects.equals(this.dhcpConfigurations(), other.dhcpConfigurations()) && Objects.equals(this.dhcpOptionsId(), other.dhcpOptionsId()) && Objects.equals(this.ownerId(), other.ownerId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DhcpOptions").add("DhcpConfigurations", this.hasDhcpConfigurations() ? this.dhcpConfigurations() : null).add("DhcpOptionsId", (Object)this.dhcpOptionsId()).add("OwnerId", (Object)this.ownerId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DhcpConfigurations": {
                return Optional.ofNullable(clazz.cast(this.dhcpConfigurations()));
            }
            case "DhcpOptionsId": {
                return Optional.ofNullable(clazz.cast(this.dhcpOptionsId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DhcpOptions, T> g) {
        return obj -> g.apply((DhcpOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DhcpConfiguration> dhcpConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String dhcpOptionsId;
        private String ownerId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DhcpOptions model) {
            this.dhcpConfigurations(model.dhcpConfigurations);
            this.dhcpOptionsId(model.dhcpOptionsId);
            this.ownerId(model.ownerId);
            this.tags(model.tags);
        }

        public final List<DhcpConfiguration.Builder> getDhcpConfigurations() {
            List<DhcpConfiguration.Builder> result = DhcpConfigurationListCopier.copyToBuilder(this.dhcpConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDhcpConfigurations(Collection<DhcpConfiguration.BuilderImpl> dhcpConfigurations) {
            this.dhcpConfigurations = DhcpConfigurationListCopier.copyFromBuilder(dhcpConfigurations);
        }

        @Override
        public final Builder dhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = DhcpConfigurationListCopier.copy(dhcpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(DhcpConfiguration ... dhcpConfigurations) {
            this.dhcpConfigurations(Arrays.asList(dhcpConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(Consumer<DhcpConfiguration.Builder> ... dhcpConfigurations) {
            this.dhcpConfigurations(Stream.of(dhcpConfigurations).map(c -> (DhcpConfiguration)((DhcpConfiguration.Builder)DhcpConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDhcpOptionsId() {
            return this.dhcpOptionsId;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DhcpOptions build() {
            return new DhcpOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DhcpOptions> {
        public Builder dhcpConfigurations(Collection<DhcpConfiguration> var1);

        public Builder dhcpConfigurations(DhcpConfiguration ... var1);

        public Builder dhcpConfigurations(Consumer<DhcpConfiguration.Builder> ... var1);

        public Builder dhcpOptionsId(String var1);

        public Builder ownerId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

