/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeer;

public class DescribeTransitGatewayConnectPeersPublisher
implements SdkPublisher<DescribeTransitGatewayConnectPeersResponse> {
    private final Ec2AsyncClient client;
    private final DescribeTransitGatewayConnectPeersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTransitGatewayConnectPeersPublisher(Ec2AsyncClient client, DescribeTransitGatewayConnectPeersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTransitGatewayConnectPeersPublisher(Ec2AsyncClient client, DescribeTransitGatewayConnectPeersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTransitGatewayConnectPeersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTransitGatewayConnectPeersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransitGatewayConnectPeer> transitGatewayConnectPeers() {
        Function<DescribeTransitGatewayConnectPeersResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayConnectPeers() != null) {
                return response.transitGatewayConnectPeers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTransitGatewayConnectPeersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTransitGatewayConnectPeersResponseFetcher
    implements AsyncPageFetcher<DescribeTransitGatewayConnectPeersResponse> {
        private DescribeTransitGatewayConnectPeersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayConnectPeersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTransitGatewayConnectPeersResponse> nextPage(DescribeTransitGatewayConnectPeersResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayConnectPeersPublisher.this.client.describeTransitGatewayConnectPeers(DescribeTransitGatewayConnectPeersPublisher.this.firstRequest);
            }
            return DescribeTransitGatewayConnectPeersPublisher.this.client.describeTransitGatewayConnectPeers((DescribeTransitGatewayConnectPeersRequest)((Object)DescribeTransitGatewayConnectPeersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

