/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.CarrierGateway;
import software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse;

public class DescribeCarrierGatewaysIterable
implements SdkIterable<DescribeCarrierGatewaysResponse> {
    private final Ec2Client client;
    private final DescribeCarrierGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCarrierGatewaysIterable(Ec2Client client, DescribeCarrierGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCarrierGatewaysResponseFetcher();
    }

    public Iterator<DescribeCarrierGatewaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CarrierGateway> carrierGateways() {
        Function<DescribeCarrierGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.carrierGateways() != null) {
                return response.carrierGateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCarrierGatewaysResponseFetcher
    implements SyncPageFetcher<DescribeCarrierGatewaysResponse> {
        private DescribeCarrierGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCarrierGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCarrierGatewaysResponse nextPage(DescribeCarrierGatewaysResponse previousPage) {
            if (previousPage == null) {
                return DescribeCarrierGatewaysIterable.this.client.describeCarrierGateways(DescribeCarrierGatewaysIterable.this.firstRequest);
            }
            return DescribeCarrierGatewaysIterable.this.client.describeCarrierGateways((DescribeCarrierGatewaysRequest)((Object)DescribeCarrierGatewaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

