/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ArchitectureValues;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.BootModeValues;
import software.amazon.awssdk.services.ec2.model.DeviceType;
import software.amazon.awssdk.services.ec2.model.HypervisorType;
import software.amazon.awssdk.services.ec2.model.ImageState;
import software.amazon.awssdk.services.ec2.model.ImageTypeValues;
import software.amazon.awssdk.services.ec2.model.ImdsSupportValues;
import software.amazon.awssdk.services.ec2.model.PlatformValues;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.services.ec2.model.StateReason;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TpmSupportValues;
import software.amazon.awssdk.services.ec2.model.VirtualizationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Image
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Image> {
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Architecture").getter(Image.getter(Image::architectureAsString)).setter(Image.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").unmarshallLocationName("architecture").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(Image.getter(Image::creationDate)).setter(Image.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").unmarshallLocationName("creationDate").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(Image.getter(Image::imageId)).setter(Image.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> IMAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageLocation").getter(Image.getter(Image::imageLocation)).setter(Image.setter(Builder::imageLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageLocation").unmarshallLocationName("imageLocation").build()}).build();
    private static final SdkField<String> IMAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageType").getter(Image.getter(Image::imageTypeAsString)).setter(Image.setter(Builder::imageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageType").unmarshallLocationName("imageType").build()}).build();
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KernelId").getter(Image.getter(Image::kernelId)).setter(Image.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").unmarshallLocationName("kernelId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(Image.getter(Image::ownerId)).setter(Image.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageOwnerId").unmarshallLocationName("imageOwnerId").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(Image.getter(Image::platformAsString)).setter(Image.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").unmarshallLocationName("platform").build()}).build();
    private static final SdkField<String> PLATFORM_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformDetails").getter(Image.getter(Image::platformDetails)).setter(Image.setter(Builder::platformDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformDetails").unmarshallLocationName("platformDetails").build()}).build();
    private static final SdkField<String> USAGE_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageOperation").getter(Image.getter(Image::usageOperation)).setter(Image.setter(Builder::usageOperation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperation").unmarshallLocationName("usageOperation").build()}).build();
    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductCodes").getter(Image.getter(Image::productCodes)).setter(Image.setter(Builder::productCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes").unmarshallLocationName("productCodes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RamdiskId").getter(Image.getter(Image::ramdiskId)).setter(Image.setter(Builder::ramdiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").unmarshallLocationName("ramdiskId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Image.getter(Image::stateAsString)).setter(Image.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageState").unmarshallLocationName("imageState").build()}).build();
    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(Image.getter(Image::blockDeviceMappings)).setter(Image.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("blockDeviceMapping").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Image.getter(Image::description)).setter(Image.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Boolean> ENA_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnaSupport").getter(Image.getter(Image::enaSupport)).setter(Image.setter(Builder::enaSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport").unmarshallLocationName("enaSupport").build()}).build();
    private static final SdkField<String> HYPERVISOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hypervisor").getter(Image.getter(Image::hypervisorAsString)).setter(Image.setter(Builder::hypervisor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisor").unmarshallLocationName("hypervisor").build()}).build();
    private static final SdkField<String> IMAGE_OWNER_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageOwnerAlias").getter(Image.getter(Image::imageOwnerAlias)).setter(Image.setter(Builder::imageOwnerAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageOwnerAlias").unmarshallLocationName("imageOwnerAlias").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Image.getter(Image::name)).setter(Image.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> ROOT_DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootDeviceName").getter(Image.getter(Image::rootDeviceName)).setter(Image.setter(Builder::rootDeviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceName").unmarshallLocationName("rootDeviceName").build()}).build();
    private static final SdkField<String> ROOT_DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootDeviceType").getter(Image.getter(Image::rootDeviceTypeAsString)).setter(Image.setter(Builder::rootDeviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceType").unmarshallLocationName("rootDeviceType").build()}).build();
    private static final SdkField<String> SRIOV_NET_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SriovNetSupport").getter(Image.getter(Image::sriovNetSupport)).setter(Image.setter(Builder::sriovNetSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport").unmarshallLocationName("sriovNetSupport").build()}).build();
    private static final SdkField<StateReason> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StateReason").getter(Image.getter(Image::stateReason)).setter(Image.setter(Builder::stateReason)).constructor(StateReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").unmarshallLocationName("stateReason").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Image.getter(Image::tags)).setter(Image.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VIRTUALIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VirtualizationType").getter(Image.getter(Image::virtualizationTypeAsString)).setter(Image.setter(Builder::virtualizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType").unmarshallLocationName("virtualizationType").build()}).build();
    private static final SdkField<String> BOOT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BootMode").getter(Image.getter(Image::bootModeAsString)).setter(Image.setter(Builder::bootMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootMode").unmarshallLocationName("bootMode").build()}).build();
    private static final SdkField<String> TPM_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TpmSupport").getter(Image.getter(Image::tpmSupportAsString)).setter(Image.setter(Builder::tpmSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TpmSupport").unmarshallLocationName("tpmSupport").build()}).build();
    private static final SdkField<String> DEPRECATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeprecationTime").getter(Image.getter(Image::deprecationTime)).setter(Image.setter(Builder::deprecationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecationTime").unmarshallLocationName("deprecationTime").build()}).build();
    private static final SdkField<String> IMDS_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImdsSupport").getter(Image.getter(Image::imdsSupportAsString)).setter(Image.setter(Builder::imdsSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImdsSupport").unmarshallLocationName("imdsSupport").build()}).build();
    private static final SdkField<Boolean> PUBLIC_LAUNCH_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PublicLaunchPermissions").getter(Image.getter(Image::publicLaunchPermissions)).setter(Image.setter(Builder::publicLaunchPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPublic").unmarshallLocationName("isPublic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_FIELD, CREATION_DATE_FIELD, IMAGE_ID_FIELD, IMAGE_LOCATION_FIELD, IMAGE_TYPE_FIELD, KERNEL_ID_FIELD, OWNER_ID_FIELD, PLATFORM_FIELD, PLATFORM_DETAILS_FIELD, USAGE_OPERATION_FIELD, PRODUCT_CODES_FIELD, RAMDISK_ID_FIELD, STATE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, DESCRIPTION_FIELD, ENA_SUPPORT_FIELD, HYPERVISOR_FIELD, IMAGE_OWNER_ALIAS_FIELD, NAME_FIELD, ROOT_DEVICE_NAME_FIELD, ROOT_DEVICE_TYPE_FIELD, SRIOV_NET_SUPPORT_FIELD, STATE_REASON_FIELD, TAGS_FIELD, VIRTUALIZATION_TYPE_FIELD, BOOT_MODE_FIELD, TPM_SUPPORT_FIELD, DEPRECATION_TIME_FIELD, IMDS_SUPPORT_FIELD, PUBLIC_LAUNCH_PERMISSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String architecture;
    private final String creationDate;
    private final String imageId;
    private final String imageLocation;
    private final String imageType;
    private final String kernelId;
    private final String ownerId;
    private final String platform;
    private final String platformDetails;
    private final String usageOperation;
    private final List<ProductCode> productCodes;
    private final String ramdiskId;
    private final String state;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String description;
    private final Boolean enaSupport;
    private final String hypervisor;
    private final String imageOwnerAlias;
    private final String name;
    private final String rootDeviceName;
    private final String rootDeviceType;
    private final String sriovNetSupport;
    private final StateReason stateReason;
    private final List<Tag> tags;
    private final String virtualizationType;
    private final String bootMode;
    private final String tpmSupport;
    private final String deprecationTime;
    private final String imdsSupport;
    private final Boolean publicLaunchPermissions;

    private Image(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.creationDate = builder.creationDate;
        this.imageId = builder.imageId;
        this.imageLocation = builder.imageLocation;
        this.imageType = builder.imageType;
        this.kernelId = builder.kernelId;
        this.ownerId = builder.ownerId;
        this.platform = builder.platform;
        this.platformDetails = builder.platformDetails;
        this.usageOperation = builder.usageOperation;
        this.productCodes = builder.productCodes;
        this.ramdiskId = builder.ramdiskId;
        this.state = builder.state;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.enaSupport = builder.enaSupport;
        this.hypervisor = builder.hypervisor;
        this.imageOwnerAlias = builder.imageOwnerAlias;
        this.name = builder.name;
        this.rootDeviceName = builder.rootDeviceName;
        this.rootDeviceType = builder.rootDeviceType;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
        this.virtualizationType = builder.virtualizationType;
        this.bootMode = builder.bootMode;
        this.tpmSupport = builder.tpmSupport;
        this.deprecationTime = builder.deprecationTime;
        this.imdsSupport = builder.imdsSupport;
        this.publicLaunchPermissions = builder.publicLaunchPermissions;
    }

    public final ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(this.architecture);
    }

    public final String architectureAsString() {
        return this.architecture;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String imageLocation() {
        return this.imageLocation;
    }

    public final ImageTypeValues imageType() {
        return ImageTypeValues.fromValue(this.imageType);
    }

    public final String imageTypeAsString() {
        return this.imageType;
    }

    public final String kernelId() {
        return this.kernelId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final PlatformValues platform() {
        return PlatformValues.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final String platformDetails() {
        return this.platformDetails;
    }

    public final String usageOperation() {
        return this.usageOperation;
    }

    public final boolean hasProductCodes() {
        return this.productCodes != null && !(this.productCodes instanceof SdkAutoConstructList);
    }

    public final List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public final String ramdiskId() {
        return this.ramdiskId;
    }

    public final ImageState state() {
        return ImageState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean enaSupport() {
        return this.enaSupport;
    }

    public final HypervisorType hypervisor() {
        return HypervisorType.fromValue(this.hypervisor);
    }

    public final String hypervisorAsString() {
        return this.hypervisor;
    }

    public final String imageOwnerAlias() {
        return this.imageOwnerAlias;
    }

    public final String name() {
        return this.name;
    }

    public final String rootDeviceName() {
        return this.rootDeviceName;
    }

    public final DeviceType rootDeviceType() {
        return DeviceType.fromValue(this.rootDeviceType);
    }

    public final String rootDeviceTypeAsString() {
        return this.rootDeviceType;
    }

    public final String sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public final StateReason stateReason() {
        return this.stateReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final VirtualizationType virtualizationType() {
        return VirtualizationType.fromValue(this.virtualizationType);
    }

    public final String virtualizationTypeAsString() {
        return this.virtualizationType;
    }

    public final BootModeValues bootMode() {
        return BootModeValues.fromValue(this.bootMode);
    }

    public final String bootModeAsString() {
        return this.bootMode;
    }

    public final TpmSupportValues tpmSupport() {
        return TpmSupportValues.fromValue(this.tpmSupport);
    }

    public final String tpmSupportAsString() {
        return this.tpmSupport;
    }

    public final String deprecationTime() {
        return this.deprecationTime;
    }

    public final ImdsSupportValues imdsSupport() {
        return ImdsSupportValues.fromValue(this.imdsSupport);
    }

    public final String imdsSupportAsString() {
        return this.imdsSupport;
    }

    public final Boolean publicLaunchPermissions() {
        return this.publicLaunchPermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductCodes() ? this.productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageOwnerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tpmSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.imdsSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicLaunchPermissions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.architectureAsString(), other.architectureAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.imageLocation(), other.imageLocation()) && Objects.equals(this.imageTypeAsString(), other.imageTypeAsString()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.platformDetails(), other.platformDetails()) && Objects.equals(this.usageOperation(), other.usageOperation()) && this.hasProductCodes() == other.hasProductCodes() && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enaSupport(), other.enaSupport()) && Objects.equals(this.hypervisorAsString(), other.hypervisorAsString()) && Objects.equals(this.imageOwnerAlias(), other.imageOwnerAlias()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.rootDeviceName(), other.rootDeviceName()) && Objects.equals(this.rootDeviceTypeAsString(), other.rootDeviceTypeAsString()) && Objects.equals(this.sriovNetSupport(), other.sriovNetSupport()) && Objects.equals(this.stateReason(), other.stateReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.virtualizationTypeAsString(), other.virtualizationTypeAsString()) && Objects.equals(this.bootModeAsString(), other.bootModeAsString()) && Objects.equals(this.tpmSupportAsString(), other.tpmSupportAsString()) && Objects.equals(this.deprecationTime(), other.deprecationTime()) && Objects.equals(this.imdsSupportAsString(), other.imdsSupportAsString()) && Objects.equals(this.publicLaunchPermissions(), other.publicLaunchPermissions());
    }

    public final String toString() {
        return ToString.builder((String)"Image").add("Architecture", (Object)this.architectureAsString()).add("CreationDate", (Object)this.creationDate()).add("ImageId", (Object)this.imageId()).add("ImageLocation", (Object)this.imageLocation()).add("ImageType", (Object)this.imageTypeAsString()).add("KernelId", (Object)this.kernelId()).add("OwnerId", (Object)this.ownerId()).add("Platform", (Object)this.platformAsString()).add("PlatformDetails", (Object)this.platformDetails()).add("UsageOperation", (Object)this.usageOperation()).add("ProductCodes", this.hasProductCodes() ? this.productCodes() : null).add("RamdiskId", (Object)this.ramdiskId()).add("State", (Object)this.stateAsString()).add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("Description", (Object)this.description()).add("EnaSupport", (Object)this.enaSupport()).add("Hypervisor", (Object)this.hypervisorAsString()).add("ImageOwnerAlias", (Object)this.imageOwnerAlias()).add("Name", (Object)this.name()).add("RootDeviceName", (Object)this.rootDeviceName()).add("RootDeviceType", (Object)this.rootDeviceTypeAsString()).add("SriovNetSupport", (Object)this.sriovNetSupport()).add("StateReason", (Object)this.stateReason()).add("Tags", this.hasTags() ? this.tags() : null).add("VirtualizationType", (Object)this.virtualizationTypeAsString()).add("BootMode", (Object)this.bootModeAsString()).add("TpmSupport", (Object)this.tpmSupportAsString()).add("DeprecationTime", (Object)this.deprecationTime()).add("ImdsSupport", (Object)this.imdsSupportAsString()).add("PublicLaunchPermissions", (Object)this.publicLaunchPermissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Architecture": {
                return Optional.ofNullable(clazz.cast(this.architectureAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ImageLocation": {
                return Optional.ofNullable(clazz.cast(this.imageLocation()));
            }
            case "ImageType": {
                return Optional.ofNullable(clazz.cast(this.imageTypeAsString()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "PlatformDetails": {
                return Optional.ofNullable(clazz.cast(this.platformDetails()));
            }
            case "UsageOperation": {
                return Optional.ofNullable(clazz.cast(this.usageOperation()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EnaSupport": {
                return Optional.ofNullable(clazz.cast(this.enaSupport()));
            }
            case "Hypervisor": {
                return Optional.ofNullable(clazz.cast(this.hypervisorAsString()));
            }
            case "ImageOwnerAlias": {
                return Optional.ofNullable(clazz.cast(this.imageOwnerAlias()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RootDeviceName": {
                return Optional.ofNullable(clazz.cast(this.rootDeviceName()));
            }
            case "RootDeviceType": {
                return Optional.ofNullable(clazz.cast(this.rootDeviceTypeAsString()));
            }
            case "SriovNetSupport": {
                return Optional.ofNullable(clazz.cast(this.sriovNetSupport()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VirtualizationType": {
                return Optional.ofNullable(clazz.cast(this.virtualizationTypeAsString()));
            }
            case "BootMode": {
                return Optional.ofNullable(clazz.cast(this.bootModeAsString()));
            }
            case "TpmSupport": {
                return Optional.ofNullable(clazz.cast(this.tpmSupportAsString()));
            }
            case "DeprecationTime": {
                return Optional.ofNullable(clazz.cast(this.deprecationTime()));
            }
            case "ImdsSupport": {
                return Optional.ofNullable(clazz.cast(this.imdsSupportAsString()));
            }
            case "PublicLaunchPermissions": {
                return Optional.ofNullable(clazz.cast(this.publicLaunchPermissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String architecture;
        private String creationDate;
        private String imageId;
        private String imageLocation;
        private String imageType;
        private String kernelId;
        private String ownerId;
        private String platform;
        private String platformDetails;
        private String usageOperation;
        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();
        private String ramdiskId;
        private String state;
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private Boolean enaSupport;
        private String hypervisor;
        private String imageOwnerAlias;
        private String name;
        private String rootDeviceName;
        private String rootDeviceType;
        private String sriovNetSupport;
        private StateReason stateReason;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String virtualizationType;
        private String bootMode;
        private String tpmSupport;
        private String deprecationTime;
        private String imdsSupport;
        private Boolean publicLaunchPermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.architecture(model.architecture);
            this.creationDate(model.creationDate);
            this.imageId(model.imageId);
            this.imageLocation(model.imageLocation);
            this.imageType(model.imageType);
            this.kernelId(model.kernelId);
            this.ownerId(model.ownerId);
            this.platform(model.platform);
            this.platformDetails(model.platformDetails);
            this.usageOperation(model.usageOperation);
            this.productCodes(model.productCodes);
            this.ramdiskId(model.ramdiskId);
            this.state(model.state);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.description(model.description);
            this.enaSupport(model.enaSupport);
            this.hypervisor(model.hypervisor);
            this.imageOwnerAlias(model.imageOwnerAlias);
            this.name(model.name);
            this.rootDeviceName(model.rootDeviceName);
            this.rootDeviceType(model.rootDeviceType);
            this.sriovNetSupport(model.sriovNetSupport);
            this.stateReason(model.stateReason);
            this.tags(model.tags);
            this.virtualizationType(model.virtualizationType);
            this.bootMode(model.bootMode);
            this.tpmSupport(model.tpmSupport);
            this.deprecationTime(model.deprecationTime);
            this.imdsSupport(model.imdsSupport);
            this.publicLaunchPermissions(model.publicLaunchPermissions);
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getImageLocation() {
            return this.imageLocation;
        }

        public final void setImageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
        }

        @Override
        public final Builder imageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
            return this;
        }

        public final String getImageType() {
            return this.imageType;
        }

        public final void setImageType(String imageType) {
            this.imageType = imageType;
        }

        @Override
        public final Builder imageType(String imageType) {
            this.imageType = imageType;
            return this;
        }

        @Override
        public final Builder imageType(ImageTypeValues imageType) {
            this.imageType(imageType == null ? null : imageType.toString());
            return this;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getPlatformDetails() {
            return this.platformDetails;
        }

        public final void setPlatformDetails(String platformDetails) {
            this.platformDetails = platformDetails;
        }

        @Override
        public final Builder platformDetails(String platformDetails) {
            this.platformDetails = platformDetails;
            return this;
        }

        public final String getUsageOperation() {
            return this.usageOperation;
        }

        public final void setUsageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
        }

        @Override
        public final Builder usageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
            return this;
        }

        public final List<ProductCode.Builder> getProductCodes() {
            List<ProductCode.Builder> result = ProductCodeListCopier.copyToBuilder(this.productCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEnaSupport() {
            return this.enaSupport;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final String getHypervisor() {
            return this.hypervisor;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public final Builder hypervisor(HypervisorType hypervisor) {
            this.hypervisor(hypervisor == null ? null : hypervisor.toString());
            return this;
        }

        public final String getImageOwnerAlias() {
            return this.imageOwnerAlias;
        }

        public final void setImageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
        }

        @Override
        public final Builder imageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRootDeviceName() {
            return this.rootDeviceName;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final String getRootDeviceType() {
            return this.rootDeviceType;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(DeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType == null ? null : rootDeviceType.toString());
            return this;
        }

        public final String getSriovNetSupport() {
            return this.sriovNetSupport;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final StateReason.Builder getStateReason() {
            return this.stateReason != null ? this.stateReason.toBuilder() : null;
        }

        public final void setStateReason(StateReason.BuilderImpl stateReason) {
            this.stateReason = stateReason != null ? stateReason.build() : null;
        }

        @Override
        public final Builder stateReason(StateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVirtualizationType() {
            return this.virtualizationType;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType == null ? null : virtualizationType.toString());
            return this;
        }

        public final String getBootMode() {
            return this.bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootModeValues bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        public final String getTpmSupport() {
            return this.tpmSupport;
        }

        public final void setTpmSupport(String tpmSupport) {
            this.tpmSupport = tpmSupport;
        }

        @Override
        public final Builder tpmSupport(String tpmSupport) {
            this.tpmSupport = tpmSupport;
            return this;
        }

        @Override
        public final Builder tpmSupport(TpmSupportValues tpmSupport) {
            this.tpmSupport(tpmSupport == null ? null : tpmSupport.toString());
            return this;
        }

        public final String getDeprecationTime() {
            return this.deprecationTime;
        }

        public final void setDeprecationTime(String deprecationTime) {
            this.deprecationTime = deprecationTime;
        }

        @Override
        public final Builder deprecationTime(String deprecationTime) {
            this.deprecationTime = deprecationTime;
            return this;
        }

        public final String getImdsSupport() {
            return this.imdsSupport;
        }

        public final void setImdsSupport(String imdsSupport) {
            this.imdsSupport = imdsSupport;
        }

        @Override
        public final Builder imdsSupport(String imdsSupport) {
            this.imdsSupport = imdsSupport;
            return this;
        }

        @Override
        public final Builder imdsSupport(ImdsSupportValues imdsSupport) {
            this.imdsSupport(imdsSupport == null ? null : imdsSupport.toString());
            return this;
        }

        public final Boolean getPublicLaunchPermissions() {
            return this.publicLaunchPermissions;
        }

        public final void setPublicLaunchPermissions(Boolean publicLaunchPermissions) {
            this.publicLaunchPermissions = publicLaunchPermissions;
        }

        @Override
        public final Builder publicLaunchPermissions(Boolean publicLaunchPermissions) {
            this.publicLaunchPermissions = publicLaunchPermissions;
            return this;
        }

        public Image build() {
            return new Image(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Image> {
        public Builder architecture(String var1);

        public Builder architecture(ArchitectureValues var1);

        public Builder creationDate(String var1);

        public Builder imageId(String var1);

        public Builder imageLocation(String var1);

        public Builder imageType(String var1);

        public Builder imageType(ImageTypeValues var1);

        public Builder kernelId(String var1);

        public Builder ownerId(String var1);

        public Builder platform(String var1);

        public Builder platform(PlatformValues var1);

        public Builder platformDetails(String var1);

        public Builder usageOperation(String var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);

        public Builder ramdiskId(String var1);

        public Builder state(String var1);

        public Builder state(ImageState var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder description(String var1);

        public Builder enaSupport(Boolean var1);

        public Builder hypervisor(String var1);

        public Builder hypervisor(HypervisorType var1);

        public Builder imageOwnerAlias(String var1);

        public Builder name(String var1);

        public Builder rootDeviceName(String var1);

        public Builder rootDeviceType(String var1);

        public Builder rootDeviceType(DeviceType var1);

        public Builder sriovNetSupport(String var1);

        public Builder stateReason(StateReason var1);

        default public Builder stateReason(Consumer<StateReason.Builder> stateReason) {
            return this.stateReason((StateReason)((StateReason.Builder)StateReason.builder().applyMutation(stateReason)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder virtualizationType(String var1);

        public Builder virtualizationType(VirtualizationType var1);

        public Builder bootMode(String var1);

        public Builder bootMode(BootModeValues var1);

        public Builder tpmSupport(String var1);

        public Builder tpmSupport(TpmSupportValues var1);

        public Builder deprecationTime(String var1);

        public Builder imdsSupport(String var1);

        public Builder imdsSupport(ImdsSupportValues var1);

        public Builder publicLaunchPermissions(Boolean var1);
    }
}

