/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The BGP configuration information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayAttachmentBgpConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayAttachmentBgpConfiguration.Builder, TransitGatewayAttachmentBgpConfiguration> {
    private static final SdkField<Long> TRANSIT_GATEWAY_ASN_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TransitGatewayAsn")
            .getter(getter(TransitGatewayAttachmentBgpConfiguration::transitGatewayAsn))
            .setter(setter(Builder::transitGatewayAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAsn")
                    .unmarshallLocationName("transitGatewayAsn").build()).build();

    private static final SdkField<Long> PEER_ASN_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("PeerAsn")
            .getter(getter(TransitGatewayAttachmentBgpConfiguration::peerAsn))
            .setter(setter(Builder::peerAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAsn")
                    .unmarshallLocationName("peerAsn").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAddress")
            .getter(getter(TransitGatewayAttachmentBgpConfiguration::transitGatewayAddress))
            .setter(setter(Builder::transitGatewayAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAddress")
                    .unmarshallLocationName("transitGatewayAddress").build()).build();

    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerAddress")
            .getter(getter(TransitGatewayAttachmentBgpConfiguration::peerAddress))
            .setter(setter(Builder::peerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress")
                    .unmarshallLocationName("peerAddress").build()).build();

    private static final SdkField<String> BGP_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BgpStatus")
            .getter(getter(TransitGatewayAttachmentBgpConfiguration::bgpStatusAsString))
            .setter(setter(Builder::bgpStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpStatus")
                    .unmarshallLocationName("bgpStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ASN_FIELD,
            PEER_ASN_FIELD, TRANSIT_GATEWAY_ADDRESS_FIELD, PEER_ADDRESS_FIELD, BGP_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long transitGatewayAsn;

    private final Long peerAsn;

    private final String transitGatewayAddress;

    private final String peerAddress;

    private final String bgpStatus;

    private TransitGatewayAttachmentBgpConfiguration(BuilderImpl builder) {
        this.transitGatewayAsn = builder.transitGatewayAsn;
        this.peerAsn = builder.peerAsn;
        this.transitGatewayAddress = builder.transitGatewayAddress;
        this.peerAddress = builder.peerAddress;
        this.bgpStatus = builder.bgpStatus;
    }

    /**
     * <p>
     * The transit gateway Autonomous System Number (ASN).
     * </p>
     * 
     * @return The transit gateway Autonomous System Number (ASN).
     */
    public final Long transitGatewayAsn() {
        return transitGatewayAsn;
    }

    /**
     * <p>
     * The peer Autonomous System Number (ASN).
     * </p>
     * 
     * @return The peer Autonomous System Number (ASN).
     */
    public final Long peerAsn() {
        return peerAsn;
    }

    /**
     * <p>
     * The interior BGP peer IP address for the transit gateway.
     * </p>
     * 
     * @return The interior BGP peer IP address for the transit gateway.
     */
    public final String transitGatewayAddress() {
        return transitGatewayAddress;
    }

    /**
     * <p>
     * The interior BGP peer IP address for the appliance.
     * </p>
     * 
     * @return The interior BGP peer IP address for the appliance.
     */
    public final String peerAddress() {
        return peerAddress;
    }

    /**
     * <p>
     * The BGP status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bgpStatus} will
     * return {@link BgpStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bgpStatusAsString}.
     * </p>
     * 
     * @return The BGP status.
     * @see BgpStatus
     */
    public final BgpStatus bgpStatus() {
        return BgpStatus.fromValue(bgpStatus);
    }

    /**
     * <p>
     * The BGP status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bgpStatus} will
     * return {@link BgpStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bgpStatusAsString}.
     * </p>
     * 
     * @return The BGP status.
     * @see BgpStatus
     */
    public final String bgpStatusAsString() {
        return bgpStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAsn());
        hashCode = 31 * hashCode + Objects.hashCode(peerAsn());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAddress());
        hashCode = 31 * hashCode + Objects.hashCode(peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(bgpStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayAttachmentBgpConfiguration)) {
            return false;
        }
        TransitGatewayAttachmentBgpConfiguration other = (TransitGatewayAttachmentBgpConfiguration) obj;
        return Objects.equals(transitGatewayAsn(), other.transitGatewayAsn()) && Objects.equals(peerAsn(), other.peerAsn())
                && Objects.equals(transitGatewayAddress(), other.transitGatewayAddress())
                && Objects.equals(peerAddress(), other.peerAddress())
                && Objects.equals(bgpStatusAsString(), other.bgpStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayAttachmentBgpConfiguration").add("TransitGatewayAsn", transitGatewayAsn())
                .add("PeerAsn", peerAsn()).add("TransitGatewayAddress", transitGatewayAddress())
                .add("PeerAddress", peerAddress()).add("BgpStatus", bgpStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAsn":
            return Optional.ofNullable(clazz.cast(transitGatewayAsn()));
        case "PeerAsn":
            return Optional.ofNullable(clazz.cast(peerAsn()));
        case "TransitGatewayAddress":
            return Optional.ofNullable(clazz.cast(transitGatewayAddress()));
        case "PeerAddress":
            return Optional.ofNullable(clazz.cast(peerAddress()));
        case "BgpStatus":
            return Optional.ofNullable(clazz.cast(bgpStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayAttachmentBgpConfiguration, T> g) {
        return obj -> g.apply((TransitGatewayAttachmentBgpConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayAttachmentBgpConfiguration> {
        /**
         * <p>
         * The transit gateway Autonomous System Number (ASN).
         * </p>
         * 
         * @param transitGatewayAsn
         *        The transit gateway Autonomous System Number (ASN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAsn(Long transitGatewayAsn);

        /**
         * <p>
         * The peer Autonomous System Number (ASN).
         * </p>
         * 
         * @param peerAsn
         *        The peer Autonomous System Number (ASN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAsn(Long peerAsn);

        /**
         * <p>
         * The interior BGP peer IP address for the transit gateway.
         * </p>
         * 
         * @param transitGatewayAddress
         *        The interior BGP peer IP address for the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAddress(String transitGatewayAddress);

        /**
         * <p>
         * The interior BGP peer IP address for the appliance.
         * </p>
         * 
         * @param peerAddress
         *        The interior BGP peer IP address for the appliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAddress(String peerAddress);

        /**
         * <p>
         * The BGP status.
         * </p>
         * 
         * @param bgpStatus
         *        The BGP status.
         * @see BgpStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BgpStatus
         */
        Builder bgpStatus(String bgpStatus);

        /**
         * <p>
         * The BGP status.
         * </p>
         * 
         * @param bgpStatus
         *        The BGP status.
         * @see BgpStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BgpStatus
         */
        Builder bgpStatus(BgpStatus bgpStatus);
    }

    static final class BuilderImpl implements Builder {
        private Long transitGatewayAsn;

        private Long peerAsn;

        private String transitGatewayAddress;

        private String peerAddress;

        private String bgpStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayAttachmentBgpConfiguration model) {
            transitGatewayAsn(model.transitGatewayAsn);
            peerAsn(model.peerAsn);
            transitGatewayAddress(model.transitGatewayAddress);
            peerAddress(model.peerAddress);
            bgpStatus(model.bgpStatus);
        }

        public final Long getTransitGatewayAsn() {
            return transitGatewayAsn;
        }

        public final void setTransitGatewayAsn(Long transitGatewayAsn) {
            this.transitGatewayAsn = transitGatewayAsn;
        }

        @Override
        @Transient
        public final Builder transitGatewayAsn(Long transitGatewayAsn) {
            this.transitGatewayAsn = transitGatewayAsn;
            return this;
        }

        public final Long getPeerAsn() {
            return peerAsn;
        }

        public final void setPeerAsn(Long peerAsn) {
            this.peerAsn = peerAsn;
        }

        @Override
        @Transient
        public final Builder peerAsn(Long peerAsn) {
            this.peerAsn = peerAsn;
            return this;
        }

        public final String getTransitGatewayAddress() {
            return transitGatewayAddress;
        }

        public final void setTransitGatewayAddress(String transitGatewayAddress) {
            this.transitGatewayAddress = transitGatewayAddress;
        }

        @Override
        @Transient
        public final Builder transitGatewayAddress(String transitGatewayAddress) {
            this.transitGatewayAddress = transitGatewayAddress;
            return this;
        }

        public final String getPeerAddress() {
            return peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        @Transient
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final String getBgpStatus() {
            return bgpStatus;
        }

        public final void setBgpStatus(String bgpStatus) {
            this.bgpStatus = bgpStatus;
        }

        @Override
        @Transient
        public final Builder bgpStatus(String bgpStatus) {
            this.bgpStatus = bgpStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder bgpStatus(BgpStatus bgpStatus) {
            this.bgpStatus(bgpStatus == null ? null : bgpStatus.toString());
            return this;
        }

        @Override
        public TransitGatewayAttachmentBgpConfiguration build() {
            return new TransitGatewayAttachmentBgpConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
