/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartNetworkInsightsAccessScopeAnalysisResponse extends Ec2Response
        implements
        ToCopyableBuilder<StartNetworkInsightsAccessScopeAnalysisResponse.Builder, StartNetworkInsightsAccessScopeAnalysisResponse> {
    private static final SdkField<NetworkInsightsAccessScopeAnalysis> NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_FIELD = SdkField
            .<NetworkInsightsAccessScopeAnalysis> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkInsightsAccessScopeAnalysis")
            .getter(getter(StartNetworkInsightsAccessScopeAnalysisResponse::networkInsightsAccessScopeAnalysis))
            .setter(setter(Builder::networkInsightsAccessScopeAnalysis))
            .constructor(NetworkInsightsAccessScopeAnalysis::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeAnalysis")
                    .unmarshallLocationName("networkInsightsAccessScopeAnalysis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_FIELD));

    private final NetworkInsightsAccessScopeAnalysis networkInsightsAccessScopeAnalysis;

    private StartNetworkInsightsAccessScopeAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.networkInsightsAccessScopeAnalysis = builder.networkInsightsAccessScopeAnalysis;
    }

    /**
     * <p>
     * The Network Access Scope analysis.
     * </p>
     * 
     * @return The Network Access Scope analysis.
     */
    public final NetworkInsightsAccessScopeAnalysis networkInsightsAccessScopeAnalysis() {
        return networkInsightsAccessScopeAnalysis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsAccessScopeAnalysis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartNetworkInsightsAccessScopeAnalysisResponse)) {
            return false;
        }
        StartNetworkInsightsAccessScopeAnalysisResponse other = (StartNetworkInsightsAccessScopeAnalysisResponse) obj;
        return Objects.equals(networkInsightsAccessScopeAnalysis(), other.networkInsightsAccessScopeAnalysis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartNetworkInsightsAccessScopeAnalysisResponse")
                .add("NetworkInsightsAccessScopeAnalysis", networkInsightsAccessScopeAnalysis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsAccessScopeAnalysis":
            return Optional.ofNullable(clazz.cast(networkInsightsAccessScopeAnalysis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartNetworkInsightsAccessScopeAnalysisResponse, T> g) {
        return obj -> g.apply((StartNetworkInsightsAccessScopeAnalysisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, StartNetworkInsightsAccessScopeAnalysisResponse> {
        /**
         * <p>
         * The Network Access Scope analysis.
         * </p>
         * 
         * @param networkInsightsAccessScopeAnalysis
         *        The Network Access Scope analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAccessScopeAnalysis(NetworkInsightsAccessScopeAnalysis networkInsightsAccessScopeAnalysis);

        /**
         * <p>
         * The Network Access Scope analysis.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInsightsAccessScopeAnalysis.Builder}
         * avoiding the need to create one manually via {@link NetworkInsightsAccessScopeAnalysis#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInsightsAccessScopeAnalysis.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #networkInsightsAccessScopeAnalysis(NetworkInsightsAccessScopeAnalysis)}.
         * 
         * @param networkInsightsAccessScopeAnalysis
         *        a consumer that will call methods on {@link NetworkInsightsAccessScopeAnalysis.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInsightsAccessScopeAnalysis(NetworkInsightsAccessScopeAnalysis)
         */
        default Builder networkInsightsAccessScopeAnalysis(
                Consumer<NetworkInsightsAccessScopeAnalysis.Builder> networkInsightsAccessScopeAnalysis) {
            return networkInsightsAccessScopeAnalysis(NetworkInsightsAccessScopeAnalysis.builder()
                    .applyMutation(networkInsightsAccessScopeAnalysis).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private NetworkInsightsAccessScopeAnalysis networkInsightsAccessScopeAnalysis;

        private BuilderImpl() {
        }

        private BuilderImpl(StartNetworkInsightsAccessScopeAnalysisResponse model) {
            super(model);
            networkInsightsAccessScopeAnalysis(model.networkInsightsAccessScopeAnalysis);
        }

        public final NetworkInsightsAccessScopeAnalysis.Builder getNetworkInsightsAccessScopeAnalysis() {
            return networkInsightsAccessScopeAnalysis != null ? networkInsightsAccessScopeAnalysis.toBuilder() : null;
        }

        public final void setNetworkInsightsAccessScopeAnalysis(
                NetworkInsightsAccessScopeAnalysis.BuilderImpl networkInsightsAccessScopeAnalysis) {
            this.networkInsightsAccessScopeAnalysis = networkInsightsAccessScopeAnalysis != null ? networkInsightsAccessScopeAnalysis
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder networkInsightsAccessScopeAnalysis(
                NetworkInsightsAccessScopeAnalysis networkInsightsAccessScopeAnalysis) {
            this.networkInsightsAccessScopeAnalysis = networkInsightsAccessScopeAnalysis;
            return this;
        }

        @Override
        public StartNetworkInsightsAccessScopeAnalysisResponse build() {
            return new StartNetworkInsightsAccessScopeAnalysisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
