/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeSecurityGroupEgressResponse extends Ec2Response implements
        ToCopyableBuilder<RevokeSecurityGroupEgressResponse.Builder, RevokeSecurityGroupEgressResponse> {
    private static final SdkField<Boolean> RETURN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Return")
            .getter(getter(RevokeSecurityGroupEgressResponse::returnValue))
            .setter(setter(Builder::returnValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Return")
                    .unmarshallLocationName("return").build()).build();

    private static final SdkField<List<IpPermission>> UNKNOWN_IP_PERMISSIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("UnknownIpPermissions")
            .getter(getter(RevokeSecurityGroupEgressResponse::unknownIpPermissions))
            .setter(setter(Builder::unknownIpPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnknownIpPermissionSet")
                    .unmarshallLocationName("unknownIpPermissionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_FIELD,
            UNKNOWN_IP_PERMISSIONS_FIELD));

    private final Boolean returnValue;

    private final List<IpPermission> unknownIpPermissions;

    private RevokeSecurityGroupEgressResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
        this.unknownIpPermissions = builder.unknownIpPermissions;
    }

    /**
     * <p>
     * Returns <code>true</code> if the request succeeds; otherwise, returns an error.
     * </p>
     * 
     * @return Returns <code>true</code> if the request succeeds; otherwise, returns an error.
     */
    public final Boolean returnValue() {
        return returnValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnknownIpPermissions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnknownIpPermissions() {
        return unknownIpPermissions != null && !(unknownIpPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outbound rules that were unknown to the service. In some cases, <code>unknownIpPermissionSet</code> might be
     * in a different format from the request parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnknownIpPermissions} method.
     * </p>
     * 
     * @return The outbound rules that were unknown to the service. In some cases, <code>unknownIpPermissionSet</code>
     *         might be in a different format from the request parameter.
     */
    public final List<IpPermission> unknownIpPermissions() {
        return unknownIpPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(returnValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasUnknownIpPermissions() ? unknownIpPermissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSecurityGroupEgressResponse)) {
            return false;
        }
        RevokeSecurityGroupEgressResponse other = (RevokeSecurityGroupEgressResponse) obj;
        return Objects.equals(returnValue(), other.returnValue()) && hasUnknownIpPermissions() == other.hasUnknownIpPermissions()
                && Objects.equals(unknownIpPermissions(), other.unknownIpPermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokeSecurityGroupEgressResponse").add("Return", returnValue())
                .add("UnknownIpPermissions", hasUnknownIpPermissions() ? unknownIpPermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Return":
            return Optional.ofNullable(clazz.cast(returnValue()));
        case "UnknownIpPermissions":
            return Optional.ofNullable(clazz.cast(unknownIpPermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevokeSecurityGroupEgressResponse, T> g) {
        return obj -> g.apply((RevokeSecurityGroupEgressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, RevokeSecurityGroupEgressResponse> {
        /**
         * <p>
         * Returns <code>true</code> if the request succeeds; otherwise, returns an error.
         * </p>
         * 
         * @param returnValue
         *        Returns <code>true</code> if the request succeeds; otherwise, returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnValue(Boolean returnValue);

        /**
         * <p>
         * The outbound rules that were unknown to the service. In some cases, <code>unknownIpPermissionSet</code> might
         * be in a different format from the request parameter.
         * </p>
         * 
         * @param unknownIpPermissions
         *        The outbound rules that were unknown to the service. In some cases,
         *        <code>unknownIpPermissionSet</code> might be in a different format from the request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownIpPermissions(Collection<IpPermission> unknownIpPermissions);

        /**
         * <p>
         * The outbound rules that were unknown to the service. In some cases, <code>unknownIpPermissionSet</code> might
         * be in a different format from the request parameter.
         * </p>
         * 
         * @param unknownIpPermissions
         *        The outbound rules that were unknown to the service. In some cases,
         *        <code>unknownIpPermissionSet</code> might be in a different format from the request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownIpPermissions(IpPermission... unknownIpPermissions);

        /**
         * <p>
         * The outbound rules that were unknown to the service. In some cases, <code>unknownIpPermissionSet</code> might
         * be in a different format from the request parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpPermission>.Builder} avoiding the need to
         * create one manually via {@link List<IpPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpPermission>.Builder#build()} is called immediately and its
         * result is passed to {@link #unknownIpPermissions(List<IpPermission>)}.
         * 
         * @param unknownIpPermissions
         *        a consumer that will call methods on {@link List<IpPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unknownIpPermissions(List<IpPermission>)
         */
        Builder unknownIpPermissions(Consumer<IpPermission.Builder>... unknownIpPermissions);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Boolean returnValue;

        private List<IpPermission> unknownIpPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeSecurityGroupEgressResponse model) {
            super(model);
            returnValue(model.returnValue);
            unknownIpPermissions(model.unknownIpPermissions);
        }

        public final Boolean getReturnValue() {
            return returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        @Transient
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final List<IpPermission.Builder> getUnknownIpPermissions() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.unknownIpPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnknownIpPermissions(Collection<IpPermission.BuilderImpl> unknownIpPermissions) {
            this.unknownIpPermissions = IpPermissionListCopier.copyFromBuilder(unknownIpPermissions);
        }

        @Override
        @Transient
        public final Builder unknownIpPermissions(Collection<IpPermission> unknownIpPermissions) {
            this.unknownIpPermissions = IpPermissionListCopier.copy(unknownIpPermissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unknownIpPermissions(IpPermission... unknownIpPermissions) {
            unknownIpPermissions(Arrays.asList(unknownIpPermissions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unknownIpPermissions(Consumer<IpPermission.Builder>... unknownIpPermissions) {
            unknownIpPermissions(Stream.of(unknownIpPermissions).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RevokeSecurityGroupEgressResponse build() {
            return new RevokeSecurityGroupEgressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
