/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeSecurityGroupEgressRequest extends Ec2Request implements
        ToCopyableBuilder<RevokeSecurityGroupEgressRequest.Builder, RevokeSecurityGroupEgressRequest> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(RevokeSecurityGroupEgressRequest::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("IpPermissions")
            .getter(getter(RevokeSecurityGroupEgressRequest::ipPermissions))
            .setter(setter(Builder::ipPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissions")
                    .unmarshallLocationName("ipPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_RULE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupRuleIds")
            .getter(getter(RevokeSecurityGroupEgressRequest::securityGroupRuleIds))
            .setter(setter(Builder::securityGroupRuleIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRuleId")
                    .unmarshallLocationName("SecurityGroupRuleId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CIDR_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrIp")
            .getter(getter(RevokeSecurityGroupEgressRequest::cidrIp))
            .setter(setter(Builder::cidrIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIp")
                    .unmarshallLocationName("cidrIp").build()).build();

    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("FromPort")
            .getter(getter(RevokeSecurityGroupEgressRequest::fromPort))
            .setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort")
                    .unmarshallLocationName("fromPort").build()).build();

    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpProtocol")
            .getter(getter(RevokeSecurityGroupEgressRequest::ipProtocol))
            .setter(setter(Builder::ipProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol")
                    .unmarshallLocationName("ipProtocol").build()).build();

    private static final SdkField<Integer> TO_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ToPort")
            .getter(getter(RevokeSecurityGroupEgressRequest::toPort))
            .setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort")
                    .unmarshallLocationName("toPort").build()).build();

    private static final SdkField<String> SOURCE_SECURITY_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceSecurityGroupName")
            .getter(getter(RevokeSecurityGroupEgressRequest::sourceSecurityGroupName))
            .setter(setter(Builder::sourceSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroupName")
                    .unmarshallLocationName("sourceSecurityGroupName").build()).build();

    private static final SdkField<String> SOURCE_SECURITY_GROUP_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceSecurityGroupOwnerId")
            .getter(getter(RevokeSecurityGroupEgressRequest::sourceSecurityGroupOwnerId))
            .setter(setter(Builder::sourceSecurityGroupOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroupOwnerId")
                    .unmarshallLocationName("sourceSecurityGroupOwnerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            IP_PERMISSIONS_FIELD, SECURITY_GROUP_RULE_IDS_FIELD, CIDR_IP_FIELD, FROM_PORT_FIELD, IP_PROTOCOL_FIELD,
            TO_PORT_FIELD, SOURCE_SECURITY_GROUP_NAME_FIELD, SOURCE_SECURITY_GROUP_OWNER_ID_FIELD));

    private final String groupId;

    private final List<IpPermission> ipPermissions;

    private final List<String> securityGroupRuleIds;

    private final String cidrIp;

    private final Integer fromPort;

    private final String ipProtocol;

    private final Integer toPort;

    private final String sourceSecurityGroupName;

    private final String sourceSecurityGroupOwnerId;

    private RevokeSecurityGroupEgressRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.ipPermissions = builder.ipPermissions;
        this.securityGroupRuleIds = builder.securityGroupRuleIds;
        this.cidrIp = builder.cidrIp;
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.toPort = builder.toPort;
        this.sourceSecurityGroupName = builder.sourceSecurityGroupName;
        this.sourceSecurityGroupOwnerId = builder.sourceSecurityGroupOwnerId;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpPermissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpPermissions() {
        return ipPermissions != null && !(ipPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the
     * same set of permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpPermissions} method.
     * </p>
     * 
     * @return The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in
     *         the same set of permissions.
     */
    public final List<IpPermission> ipPermissions() {
        return ipPermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupRuleIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupRuleIds() {
        return securityGroupRuleIds != null && !(securityGroupRuleIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security group rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupRuleIds} method.
     * </p>
     * 
     * @return The IDs of the security group rules.
     */
    public final List<String> securityGroupRuleIds() {
        return securityGroupRuleIds;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify the CIDR.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify the CIDR.
     */
    public final String cidrIp() {
        return cidrIp;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify the port.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify the port.
     */
    public final Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify the protocol name or number.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify the protocol name or number.
     */
    public final String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify the port.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify the port.
     */
    public final Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify a destination security group.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify a destination security group.
     */
    public final String sourceSecurityGroupName() {
        return sourceSecurityGroupName;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify a destination security group.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify a destination security group.
     */
    public final String sourceSecurityGroupOwnerId() {
        return sourceSecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpPermissions() ? ipPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupRuleIds() ? securityGroupRuleIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cidrIp());
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSecurityGroupOwnerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSecurityGroupEgressRequest)) {
            return false;
        }
        RevokeSecurityGroupEgressRequest other = (RevokeSecurityGroupEgressRequest) obj;
        return Objects.equals(groupId(), other.groupId()) && hasIpPermissions() == other.hasIpPermissions()
                && Objects.equals(ipPermissions(), other.ipPermissions())
                && hasSecurityGroupRuleIds() == other.hasSecurityGroupRuleIds()
                && Objects.equals(securityGroupRuleIds(), other.securityGroupRuleIds())
                && Objects.equals(cidrIp(), other.cidrIp()) && Objects.equals(fromPort(), other.fromPort())
                && Objects.equals(ipProtocol(), other.ipProtocol()) && Objects.equals(toPort(), other.toPort())
                && Objects.equals(sourceSecurityGroupName(), other.sourceSecurityGroupName())
                && Objects.equals(sourceSecurityGroupOwnerId(), other.sourceSecurityGroupOwnerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokeSecurityGroupEgressRequest").add("GroupId", groupId())
                .add("IpPermissions", hasIpPermissions() ? ipPermissions() : null)
                .add("SecurityGroupRuleIds", hasSecurityGroupRuleIds() ? securityGroupRuleIds() : null).add("CidrIp", cidrIp())
                .add("FromPort", fromPort()).add("IpProtocol", ipProtocol()).add("ToPort", toPort())
                .add("SourceSecurityGroupName", sourceSecurityGroupName())
                .add("SourceSecurityGroupOwnerId", sourceSecurityGroupOwnerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "IpPermissions":
            return Optional.ofNullable(clazz.cast(ipPermissions()));
        case "SecurityGroupRuleIds":
            return Optional.ofNullable(clazz.cast(securityGroupRuleIds()));
        case "CidrIp":
            return Optional.ofNullable(clazz.cast(cidrIp()));
        case "FromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "IpProtocol":
            return Optional.ofNullable(clazz.cast(ipProtocol()));
        case "ToPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        case "SourceSecurityGroupName":
            return Optional.ofNullable(clazz.cast(sourceSecurityGroupName()));
        case "SourceSecurityGroupOwnerId":
            return Optional.ofNullable(clazz.cast(sourceSecurityGroupOwnerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevokeSecurityGroupEgressRequest, T> g) {
        return obj -> g.apply((RevokeSecurityGroupEgressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, RevokeSecurityGroupEgressRequest> {
        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the
         * same set of permissions.
         * </p>
         * 
         * @param ipPermissions
         *        The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range
         *        in the same set of permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(Collection<IpPermission> ipPermissions);

        /**
         * <p>
         * The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the
         * same set of permissions.
         * </p>
         * 
         * @param ipPermissions
         *        The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range
         *        in the same set of permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(IpPermission... ipPermissions);

        /**
         * <p>
         * The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the
         * same set of permissions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpPermission>.Builder} avoiding the need to
         * create one manually via {@link List<IpPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpPermission>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipPermissions(List<IpPermission>)}.
         * 
         * @param ipPermissions
         *        a consumer that will call methods on {@link List<IpPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPermissions(List<IpPermission>)
         */
        Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions);

        /**
         * <p>
         * The IDs of the security group rules.
         * </p>
         * 
         * @param securityGroupRuleIds
         *        The IDs of the security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRuleIds(Collection<String> securityGroupRuleIds);

        /**
         * <p>
         * The IDs of the security group rules.
         * </p>
         * 
         * @param securityGroupRuleIds
         *        The IDs of the security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRuleIds(String... securityGroupRuleIds);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify the CIDR.
         * </p>
         * 
         * @param cidrIp
         *        Not supported. Use a set of IP permissions to specify the CIDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIp(String cidrIp);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify the port.
         * </p>
         * 
         * @param fromPort
         *        Not supported. Use a set of IP permissions to specify the port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify the protocol name or number.
         * </p>
         * 
         * @param ipProtocol
         *        Not supported. Use a set of IP permissions to specify the protocol name or number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify the port.
         * </p>
         * 
         * @param toPort
         *        Not supported. Use a set of IP permissions to specify the port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify a destination security group.
         * </p>
         * 
         * @param sourceSecurityGroupName
         *        Not supported. Use a set of IP permissions to specify a destination security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupName(String sourceSecurityGroupName);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify a destination security group.
         * </p>
         * 
         * @param sourceSecurityGroupOwnerId
         *        Not supported. Use a set of IP permissions to specify a destination security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String groupId;

        private List<IpPermission> ipPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupRuleIds = DefaultSdkAutoConstructList.getInstance();

        private String cidrIp;

        private Integer fromPort;

        private String ipProtocol;

        private Integer toPort;

        private String sourceSecurityGroupName;

        private String sourceSecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeSecurityGroupEgressRequest model) {
            super(model);
            groupId(model.groupId);
            ipPermissions(model.ipPermissions);
            securityGroupRuleIds(model.securityGroupRuleIds);
            cidrIp(model.cidrIp);
            fromPort(model.fromPort);
            ipProtocol(model.ipProtocol);
            toPort(model.toPort);
            sourceSecurityGroupName(model.sourceSecurityGroupName);
            sourceSecurityGroupOwnerId(model.sourceSecurityGroupOwnerId);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        @Transient
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final List<IpPermission.Builder> getIpPermissions() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.ipPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        @Override
        @Transient
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipPermissions(IpPermission... ipPermissions) {
            ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions) {
            ipPermissions(Stream.of(ipPermissions).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSecurityGroupRuleIds() {
            if (securityGroupRuleIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupRuleIds;
        }

        public final void setSecurityGroupRuleIds(Collection<String> securityGroupRuleIds) {
            this.securityGroupRuleIds = SecurityGroupRuleIdListCopier.copy(securityGroupRuleIds);
        }

        @Override
        @Transient
        public final Builder securityGroupRuleIds(Collection<String> securityGroupRuleIds) {
            this.securityGroupRuleIds = SecurityGroupRuleIdListCopier.copy(securityGroupRuleIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupRuleIds(String... securityGroupRuleIds) {
            securityGroupRuleIds(Arrays.asList(securityGroupRuleIds));
            return this;
        }

        public final String getCidrIp() {
            return cidrIp;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        @Override
        @Transient
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        @Override
        @Transient
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        @Override
        @Transient
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final Integer getToPort() {
            return toPort;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        @Override
        @Transient
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final String getSourceSecurityGroupName() {
            return sourceSecurityGroupName;
        }

        public final void setSourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
        }

        @Override
        @Transient
        public final Builder sourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
            return this;
        }

        public final String getSourceSecurityGroupOwnerId() {
            return sourceSecurityGroupOwnerId;
        }

        public final void setSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
        }

        @Override
        @Transient
        public final Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeSecurityGroupEgressRequest build() {
            return new RevokeSecurityGroupEgressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
