/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetSnapshotAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<ResetSnapshotAttributeRequest.Builder, ResetSnapshotAttributeRequest> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Attribute")
            .getter(getter(ResetSnapshotAttributeRequest::attributeAsString))
            .setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute")
                    .unmarshallLocationName("Attribute").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(ResetSnapshotAttributeRequest::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("SnapshotId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            SNAPSHOT_ID_FIELD));

    private final String attribute;

    private final String snapshotId;

    private ResetSnapshotAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.snapshotId = builder.snapshotId;
    }

    /**
     * <p>
     * The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link SnapshotAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
     * @see SnapshotAttributeName
     */
    public final SnapshotAttributeName attribute() {
        return SnapshotAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link SnapshotAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
     * @see SnapshotAttributeName
     */
    public final String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetSnapshotAttributeRequest)) {
            return false;
        }
        ResetSnapshotAttributeRequest other = (ResetSnapshotAttributeRequest) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString()) && Objects.equals(snapshotId(), other.snapshotId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResetSnapshotAttributeRequest").add("Attribute", attributeAsString())
                .add("SnapshotId", snapshotId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResetSnapshotAttributeRequest, T> g) {
        return obj -> g.apply((ResetSnapshotAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ResetSnapshotAttributeRequest> {
        /**
         * <p>
         * The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
         * </p>
         * 
         * @param attribute
         *        The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
         * @see SnapshotAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
         * </p>
         * 
         * @param attribute
         *        The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
         * @see SnapshotAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotAttributeName
         */
        Builder attribute(SnapshotAttributeName attribute);

        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String attribute;

        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetSnapshotAttributeRequest model) {
            super(model);
            attribute(model.attribute);
            snapshotId(model.snapshotId);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        @Transient
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        @Transient
        public final Builder attribute(SnapshotAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        @Transient
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetSnapshotAttributeRequest build() {
            return new ResetSnapshotAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
