/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Diffie-Hellmann group number for phase 1 IKE negotiations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Phase1DHGroupNumbersListValue implements SdkPojo, Serializable,
        ToCopyableBuilder<Phase1DHGroupNumbersListValue.Builder, Phase1DHGroupNumbersListValue> {
    private static final SdkField<Integer> VALUE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Value")
            .getter(getter(Phase1DHGroupNumbersListValue::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value")
                    .unmarshallLocationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer value;

    private Phase1DHGroupNumbersListValue(BuilderImpl builder) {
        this.value = builder.value;
    }

    /**
     * <p>
     * The Diffie-Hellmann group number.
     * </p>
     * 
     * @return The Diffie-Hellmann group number.
     */
    public final Integer value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Phase1DHGroupNumbersListValue)) {
            return false;
        }
        Phase1DHGroupNumbersListValue other = (Phase1DHGroupNumbersListValue) obj;
        return Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Phase1DHGroupNumbersListValue").add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Phase1DHGroupNumbersListValue, T> g) {
        return obj -> g.apply((Phase1DHGroupNumbersListValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Phase1DHGroupNumbersListValue> {
        /**
         * <p>
         * The Diffie-Hellmann group number.
         * </p>
         * 
         * @param value
         *        The Diffie-Hellmann group number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Integer value);
    }

    static final class BuilderImpl implements Builder {
        private Integer value;

        private BuilderImpl() {
        }

        private BuilderImpl(Phase1DHGroupNumbersListValue model) {
            value(model.value);
        }

        public final Integer getValue() {
            return value;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        @Override
        public Phase1DHGroupNumbersListValue build() {
            return new Phase1DHGroupNumbersListValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
