/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Network Access Scope analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInsightsAccessScopeAnalysis implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInsightsAccessScopeAnalysis.Builder, NetworkInsightsAccessScopeAnalysis> {
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsAccessScopeAnalysisId")
            .getter(getter(NetworkInsightsAccessScopeAnalysis::networkInsightsAccessScopeAnalysisId))
            .setter(setter(Builder::networkInsightsAccessScopeAnalysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkInsightsAccessScopeAnalysisId")
                    .unmarshallLocationName("networkInsightsAccessScopeAnalysisId").build()).build();

    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsAccessScopeAnalysisArn")
            .getter(getter(NetworkInsightsAccessScopeAnalysis::networkInsightsAccessScopeAnalysisArn))
            .setter(setter(Builder::networkInsightsAccessScopeAnalysisArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkInsightsAccessScopeAnalysisArn")
                    .unmarshallLocationName("networkInsightsAccessScopeAnalysisArn").build()).build();

    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsAccessScopeId")
            .getter(getter(NetworkInsightsAccessScopeAnalysis::networkInsightsAccessScopeId))
            .setter(setter(Builder::networkInsightsAccessScopeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeId")
                    .unmarshallLocationName("networkInsightsAccessScopeId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(NetworkInsightsAccessScopeAnalysis::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage")
            .getter(getter(NetworkInsightsAccessScopeAnalysis::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<String> WARNING_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WarningMessage")
            .getter(getter(NetworkInsightsAccessScopeAnalysis::warningMessage))
            .setter(setter(Builder::warningMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarningMessage")
                    .unmarshallLocationName("warningMessage").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate")
            .getter(getter(NetworkInsightsAccessScopeAnalysis::startDate))
            .setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate")
                    .unmarshallLocationName("startDate").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate")
            .getter(getter(NetworkInsightsAccessScopeAnalysis::endDate))
            .setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate")
                    .unmarshallLocationName("endDate").build()).build();

    private static final SdkField<String> FINDINGS_FOUND_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FindingsFound")
            .getter(getter(NetworkInsightsAccessScopeAnalysis::findingsFoundAsString))
            .setter(setter(Builder::findingsFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingsFound")
                    .unmarshallLocationName("findingsFound").build()).build();

    private static final SdkField<Integer> ANALYZED_ENI_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AnalyzedEniCount")
            .getter(getter(NetworkInsightsAccessScopeAnalysis::analyzedEniCount))
            .setter(setter(Builder::analyzedEniCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzedEniCount")
                    .unmarshallLocationName("analyzedEniCount").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(NetworkInsightsAccessScopeAnalysis::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD, NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ARN_FIELD,
            NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, WARNING_MESSAGE_FIELD, START_DATE_FIELD,
            END_DATE_FIELD, FINDINGS_FOUND_FIELD, ANALYZED_ENI_COUNT_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String networkInsightsAccessScopeAnalysisId;

    private final String networkInsightsAccessScopeAnalysisArn;

    private final String networkInsightsAccessScopeId;

    private final String status;

    private final String statusMessage;

    private final String warningMessage;

    private final Instant startDate;

    private final Instant endDate;

    private final String findingsFound;

    private final Integer analyzedEniCount;

    private final List<Tag> tags;

    private NetworkInsightsAccessScopeAnalysis(BuilderImpl builder) {
        this.networkInsightsAccessScopeAnalysisId = builder.networkInsightsAccessScopeAnalysisId;
        this.networkInsightsAccessScopeAnalysisArn = builder.networkInsightsAccessScopeAnalysisArn;
        this.networkInsightsAccessScopeId = builder.networkInsightsAccessScopeId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.warningMessage = builder.warningMessage;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.findingsFound = builder.findingsFound;
        this.analyzedEniCount = builder.analyzedEniCount;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the Network Access Scope analysis.
     * </p>
     * 
     * @return The ID of the Network Access Scope analysis.
     */
    public final String networkInsightsAccessScopeAnalysisId() {
        return networkInsightsAccessScopeAnalysisId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Network Access Scope analysis.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Network Access Scope analysis.
     */
    public final String networkInsightsAccessScopeAnalysisArn() {
        return networkInsightsAccessScopeAnalysisArn;
    }

    /**
     * <p>
     * The ID of the Network Access Scope.
     * </p>
     * 
     * @return The ID of the Network Access Scope.
     */
    public final String networkInsightsAccessScopeId() {
        return networkInsightsAccessScopeId;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see AnalysisStatus
     */
    public final AnalysisStatus status() {
        return AnalysisStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see AnalysisStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message.
     * </p>
     * 
     * @return The status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The warning message.
     * </p>
     * 
     * @return The warning message.
     */
    public final String warningMessage() {
        return warningMessage;
    }

    /**
     * <p>
     * The analysis start date.
     * </p>
     * 
     * @return The analysis start date.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The analysis end date.
     * </p>
     * 
     * @return The analysis end date.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * Indicates whether there are findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #findingsFound}
     * will return {@link FindingsFound#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #findingsFoundAsString}.
     * </p>
     * 
     * @return Indicates whether there are findings.
     * @see FindingsFound
     */
    public final FindingsFound findingsFound() {
        return FindingsFound.fromValue(findingsFound);
    }

    /**
     * <p>
     * Indicates whether there are findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #findingsFound}
     * will return {@link FindingsFound#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #findingsFoundAsString}.
     * </p>
     * 
     * @return Indicates whether there are findings.
     * @see FindingsFound
     */
    public final String findingsFoundAsString() {
        return findingsFound;
    }

    /**
     * <p>
     * The number of network interfaces analyzed.
     * </p>
     * 
     * @return The number of network interfaces analyzed.
     */
    public final Integer analyzedEniCount() {
        return analyzedEniCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsAccessScopeAnalysisId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsAccessScopeAnalysisArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsAccessScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(warningMessage());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(findingsFoundAsString());
        hashCode = 31 * hashCode + Objects.hashCode(analyzedEniCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInsightsAccessScopeAnalysis)) {
            return false;
        }
        NetworkInsightsAccessScopeAnalysis other = (NetworkInsightsAccessScopeAnalysis) obj;
        return Objects.equals(networkInsightsAccessScopeAnalysisId(), other.networkInsightsAccessScopeAnalysisId())
                && Objects.equals(networkInsightsAccessScopeAnalysisArn(), other.networkInsightsAccessScopeAnalysisArn())
                && Objects.equals(networkInsightsAccessScopeId(), other.networkInsightsAccessScopeId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(warningMessage(), other.warningMessage()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(endDate(), other.endDate())
                && Objects.equals(findingsFoundAsString(), other.findingsFoundAsString())
                && Objects.equals(analyzedEniCount(), other.analyzedEniCount()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInsightsAccessScopeAnalysis")
                .add("NetworkInsightsAccessScopeAnalysisId", networkInsightsAccessScopeAnalysisId())
                .add("NetworkInsightsAccessScopeAnalysisArn", networkInsightsAccessScopeAnalysisArn())
                .add("NetworkInsightsAccessScopeId", networkInsightsAccessScopeId()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("WarningMessage", warningMessage()).add("StartDate", startDate())
                .add("EndDate", endDate()).add("FindingsFound", findingsFoundAsString())
                .add("AnalyzedEniCount", analyzedEniCount()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsAccessScopeAnalysisId":
            return Optional.ofNullable(clazz.cast(networkInsightsAccessScopeAnalysisId()));
        case "NetworkInsightsAccessScopeAnalysisArn":
            return Optional.ofNullable(clazz.cast(networkInsightsAccessScopeAnalysisArn()));
        case "NetworkInsightsAccessScopeId":
            return Optional.ofNullable(clazz.cast(networkInsightsAccessScopeId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "WarningMessage":
            return Optional.ofNullable(clazz.cast(warningMessage()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "FindingsFound":
            return Optional.ofNullable(clazz.cast(findingsFoundAsString()));
        case "AnalyzedEniCount":
            return Optional.ofNullable(clazz.cast(analyzedEniCount()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInsightsAccessScopeAnalysis, T> g) {
        return obj -> g.apply((NetworkInsightsAccessScopeAnalysis) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInsightsAccessScopeAnalysis> {
        /**
         * <p>
         * The ID of the Network Access Scope analysis.
         * </p>
         * 
         * @param networkInsightsAccessScopeAnalysisId
         *        The ID of the Network Access Scope analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Network Access Scope analysis.
         * </p>
         * 
         * @param networkInsightsAccessScopeAnalysisArn
         *        The Amazon Resource Name (ARN) of the Network Access Scope analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAccessScopeAnalysisArn(String networkInsightsAccessScopeAnalysisArn);

        /**
         * <p>
         * The ID of the Network Access Scope.
         * </p>
         * 
         * @param networkInsightsAccessScopeId
         *        The ID of the Network Access Scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see AnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisStatus
         */
        Builder status(AnalysisStatus status);

        /**
         * <p>
         * The status message.
         * </p>
         * 
         * @param statusMessage
         *        The status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The warning message.
         * </p>
         * 
         * @param warningMessage
         *        The warning message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warningMessage(String warningMessage);

        /**
         * <p>
         * The analysis start date.
         * </p>
         * 
         * @param startDate
         *        The analysis start date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The analysis end date.
         * </p>
         * 
         * @param endDate
         *        The analysis end date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * Indicates whether there are findings.
         * </p>
         * 
         * @param findingsFound
         *        Indicates whether there are findings.
         * @see FindingsFound
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingsFound
         */
        Builder findingsFound(String findingsFound);

        /**
         * <p>
         * Indicates whether there are findings.
         * </p>
         * 
         * @param findingsFound
         *        Indicates whether there are findings.
         * @see FindingsFound
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingsFound
         */
        Builder findingsFound(FindingsFound findingsFound);

        /**
         * <p>
         * The number of network interfaces analyzed.
         * </p>
         * 
         * @param analyzedEniCount
         *        The number of network interfaces analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzedEniCount(Integer analyzedEniCount);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String networkInsightsAccessScopeAnalysisId;

        private String networkInsightsAccessScopeAnalysisArn;

        private String networkInsightsAccessScopeId;

        private String status;

        private String statusMessage;

        private String warningMessage;

        private Instant startDate;

        private Instant endDate;

        private String findingsFound;

        private Integer analyzedEniCount;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInsightsAccessScopeAnalysis model) {
            networkInsightsAccessScopeAnalysisId(model.networkInsightsAccessScopeAnalysisId);
            networkInsightsAccessScopeAnalysisArn(model.networkInsightsAccessScopeAnalysisArn);
            networkInsightsAccessScopeId(model.networkInsightsAccessScopeId);
            status(model.status);
            statusMessage(model.statusMessage);
            warningMessage(model.warningMessage);
            startDate(model.startDate);
            endDate(model.endDate);
            findingsFound(model.findingsFound);
            analyzedEniCount(model.analyzedEniCount);
            tags(model.tags);
        }

        public final String getNetworkInsightsAccessScopeAnalysisId() {
            return networkInsightsAccessScopeAnalysisId;
        }

        public final void setNetworkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
        }

        @Override
        @Transient
        public final Builder networkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
            return this;
        }

        public final String getNetworkInsightsAccessScopeAnalysisArn() {
            return networkInsightsAccessScopeAnalysisArn;
        }

        public final void setNetworkInsightsAccessScopeAnalysisArn(String networkInsightsAccessScopeAnalysisArn) {
            this.networkInsightsAccessScopeAnalysisArn = networkInsightsAccessScopeAnalysisArn;
        }

        @Override
        @Transient
        public final Builder networkInsightsAccessScopeAnalysisArn(String networkInsightsAccessScopeAnalysisArn) {
            this.networkInsightsAccessScopeAnalysisArn = networkInsightsAccessScopeAnalysisArn;
            return this;
        }

        public final String getNetworkInsightsAccessScopeId() {
            return networkInsightsAccessScopeId;
        }

        public final void setNetworkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
        }

        @Override
        @Transient
        public final Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(AnalysisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getWarningMessage() {
            return warningMessage;
        }

        public final void setWarningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
        }

        @Override
        @Transient
        public final Builder warningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        @Transient
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        @Transient
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getFindingsFound() {
            return findingsFound;
        }

        public final void setFindingsFound(String findingsFound) {
            this.findingsFound = findingsFound;
        }

        @Override
        @Transient
        public final Builder findingsFound(String findingsFound) {
            this.findingsFound = findingsFound;
            return this;
        }

        @Override
        @Transient
        public final Builder findingsFound(FindingsFound findingsFound) {
            this.findingsFound(findingsFound == null ? null : findingsFound.toString());
            return this;
        }

        public final Integer getAnalyzedEniCount() {
            return analyzedEniCount;
        }

        public final void setAnalyzedEniCount(Integer analyzedEniCount) {
            this.analyzedEniCount = analyzedEniCount;
        }

        @Override
        @Transient
        public final Builder analyzedEniCount(Integer analyzedEniCount) {
            this.analyzedEniCount = analyzedEniCount;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public NetworkInsightsAccessScopeAnalysis build() {
            return new NetworkInsightsAccessScopeAnalysis(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
