/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstancePlacementRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyInstancePlacementRequest.Builder, ModifyInstancePlacementRequest> {
    private static final SdkField<String> AFFINITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Affinity")
            .getter(getter(ModifyInstancePlacementRequest::affinityAsString))
            .setter(setter(Builder::affinity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Affinity")
                    .unmarshallLocationName("affinity").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupName")
            .getter(getter(ModifyInstancePlacementRequest::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("GroupName").build()).build();

    private static final SdkField<String> HOST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostId")
            .getter(getter(ModifyInstancePlacementRequest::hostId))
            .setter(setter(Builder::hostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId")
                    .unmarshallLocationName("hostId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(ModifyInstancePlacementRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Tenancy")
            .getter(getter(ModifyInstancePlacementRequest::tenancyAsString))
            .setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy")
                    .unmarshallLocationName("tenancy").build()).build();

    private static final SdkField<Integer> PARTITION_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PartitionNumber")
            .getter(getter(ModifyInstancePlacementRequest::partitionNumber))
            .setter(setter(Builder::partitionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionNumber")
                    .unmarshallLocationName("PartitionNumber").build()).build();

    private static final SdkField<String> HOST_RESOURCE_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostResourceGroupArn")
            .getter(getter(ModifyInstancePlacementRequest::hostResourceGroupArn))
            .setter(setter(Builder::hostResourceGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostResourceGroupArn")
                    .unmarshallLocationName("HostResourceGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFINITY_FIELD,
            GROUP_NAME_FIELD, HOST_ID_FIELD, INSTANCE_ID_FIELD, TENANCY_FIELD, PARTITION_NUMBER_FIELD,
            HOST_RESOURCE_GROUP_ARN_FIELD));

    private final String affinity;

    private final String groupName;

    private final String hostId;

    private final String instanceId;

    private final String tenancy;

    private final Integer partitionNumber;

    private final String hostResourceGroupArn;

    private ModifyInstancePlacementRequest(BuilderImpl builder) {
        super(builder);
        this.affinity = builder.affinity;
        this.groupName = builder.groupName;
        this.hostId = builder.hostId;
        this.instanceId = builder.instanceId;
        this.tenancy = builder.tenancy;
        this.partitionNumber = builder.partitionNumber;
        this.hostResourceGroupArn = builder.hostResourceGroupArn;
    }

    /**
     * <p>
     * The affinity setting for the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #affinity} will
     * return {@link Affinity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #affinityAsString}.
     * </p>
     * 
     * @return The affinity setting for the instance.
     * @see Affinity
     */
    public final Affinity affinity() {
        return Affinity.fromValue(affinity);
    }

    /**
     * <p>
     * The affinity setting for the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #affinity} will
     * return {@link Affinity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #affinityAsString}.
     * </p>
     * 
     * @return The affinity setting for the instance.
     * @see Affinity
     */
    public final String affinityAsString() {
        return affinity;
    }

    /**
     * <p>
     * The name of the placement group in which to place the instance. For spread placement groups, the instance must
     * have a tenancy of <code>default</code>. For cluster and partition placement groups, the instance must have a
     * tenancy of <code>default</code> or <code>dedicated</code>.
     * </p>
     * <p>
     * To remove an instance from a placement group, specify an empty string ("").
     * </p>
     * 
     * @return The name of the placement group in which to place the instance. For spread placement groups, the instance
     *         must have a tenancy of <code>default</code>. For cluster and partition placement groups, the instance
     *         must have a tenancy of <code>default</code> or <code>dedicated</code>.</p>
     *         <p>
     *         To remove an instance from a placement group, specify an empty string ("").
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The ID of the Dedicated Host with which to associate the instance.
     * </p>
     * 
     * @return The ID of the Dedicated Host with which to associate the instance.
     */
    public final String hostId() {
        return hostId;
    }

    /**
     * <p>
     * The ID of the instance that you are modifying.
     * </p>
     * 
     * @return The ID of the instance that you are modifying.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The tenancy for the instance.
     * </p>
     * <note>
     * <p>
     * For T3 instances, you can't change the tenancy from <code>dedicated</code> to <code>host</code>, or from
     * <code>host</code> to <code>dedicated</code>. Attempting to make one of these unsupported tenancy changes results
     * in the <code>InvalidTenancy</code> error code.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link HostTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return The tenancy for the instance.</p> <note>
     *         <p>
     *         For T3 instances, you can't change the tenancy from <code>dedicated</code> to <code>host</code>, or from
     *         <code>host</code> to <code>dedicated</code>. Attempting to make one of these unsupported tenancy changes
     *         results in the <code>InvalidTenancy</code> error code.
     *         </p>
     * @see HostTenancy
     */
    public final HostTenancy tenancy() {
        return HostTenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * The tenancy for the instance.
     * </p>
     * <note>
     * <p>
     * For T3 instances, you can't change the tenancy from <code>dedicated</code> to <code>host</code>, or from
     * <code>host</code> to <code>dedicated</code>. Attempting to make one of these unsupported tenancy changes results
     * in the <code>InvalidTenancy</code> error code.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link HostTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return The tenancy for the instance.</p> <note>
     *         <p>
     *         For T3 instances, you can't change the tenancy from <code>dedicated</code> to <code>host</code>, or from
     *         <code>host</code> to <code>dedicated</code>. Attempting to make one of these unsupported tenancy changes
     *         results in the <code>InvalidTenancy</code> error code.
     *         </p>
     * @see HostTenancy
     */
    public final String tenancyAsString() {
        return tenancy;
    }

    /**
     * <p>
     * The number of the partition in which to place the instance. Valid only if the placement group strategy is set to
     * <code>partition</code>.
     * </p>
     * 
     * @return The number of the partition in which to place the instance. Valid only if the placement group strategy is
     *         set to <code>partition</code>.
     */
    public final Integer partitionNumber() {
        return partitionNumber;
    }

    /**
     * <p>
     * The ARN of the host resource group in which to place the instance.
     * </p>
     * 
     * @return The ARN of the host resource group in which to place the instance.
     */
    public final String hostResourceGroupArn() {
        return hostResourceGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(affinityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(hostId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(partitionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hostResourceGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstancePlacementRequest)) {
            return false;
        }
        ModifyInstancePlacementRequest other = (ModifyInstancePlacementRequest) obj;
        return Objects.equals(affinityAsString(), other.affinityAsString()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(hostId(), other.hostId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(tenancyAsString(), other.tenancyAsString())
                && Objects.equals(partitionNumber(), other.partitionNumber())
                && Objects.equals(hostResourceGroupArn(), other.hostResourceGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstancePlacementRequest").add("Affinity", affinityAsString())
                .add("GroupName", groupName()).add("HostId", hostId()).add("InstanceId", instanceId())
                .add("Tenancy", tenancyAsString()).add("PartitionNumber", partitionNumber())
                .add("HostResourceGroupArn", hostResourceGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Affinity":
            return Optional.ofNullable(clazz.cast(affinityAsString()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "HostId":
            return Optional.ofNullable(clazz.cast(hostId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancyAsString()));
        case "PartitionNumber":
            return Optional.ofNullable(clazz.cast(partitionNumber()));
        case "HostResourceGroupArn":
            return Optional.ofNullable(clazz.cast(hostResourceGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstancePlacementRequest, T> g) {
        return obj -> g.apply((ModifyInstancePlacementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyInstancePlacementRequest> {
        /**
         * <p>
         * The affinity setting for the instance.
         * </p>
         * 
         * @param affinity
         *        The affinity setting for the instance.
         * @see Affinity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Affinity
         */
        Builder affinity(String affinity);

        /**
         * <p>
         * The affinity setting for the instance.
         * </p>
         * 
         * @param affinity
         *        The affinity setting for the instance.
         * @see Affinity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Affinity
         */
        Builder affinity(Affinity affinity);

        /**
         * <p>
         * The name of the placement group in which to place the instance. For spread placement groups, the instance
         * must have a tenancy of <code>default</code>. For cluster and partition placement groups, the instance must
         * have a tenancy of <code>default</code> or <code>dedicated</code>.
         * </p>
         * <p>
         * To remove an instance from a placement group, specify an empty string ("").
         * </p>
         * 
         * @param groupName
         *        The name of the placement group in which to place the instance. For spread placement groups, the
         *        instance must have a tenancy of <code>default</code>. For cluster and partition placement groups, the
         *        instance must have a tenancy of <code>default</code> or <code>dedicated</code>.</p>
         *        <p>
         *        To remove an instance from a placement group, specify an empty string ("").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The ID of the Dedicated Host with which to associate the instance.
         * </p>
         * 
         * @param hostId
         *        The ID of the Dedicated Host with which to associate the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostId(String hostId);

        /**
         * <p>
         * The ID of the instance that you are modifying.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance that you are modifying.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The tenancy for the instance.
         * </p>
         * <note>
         * <p>
         * For T3 instances, you can't change the tenancy from <code>dedicated</code> to <code>host</code>, or from
         * <code>host</code> to <code>dedicated</code>. Attempting to make one of these unsupported tenancy changes
         * results in the <code>InvalidTenancy</code> error code.
         * </p>
         * </note>
         * 
         * @param tenancy
         *        The tenancy for the instance.</p> <note>
         *        <p>
         *        For T3 instances, you can't change the tenancy from <code>dedicated</code> to <code>host</code>, or
         *        from <code>host</code> to <code>dedicated</code>. Attempting to make one of these unsupported tenancy
         *        changes results in the <code>InvalidTenancy</code> error code.
         *        </p>
         * @see HostTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostTenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * The tenancy for the instance.
         * </p>
         * <note>
         * <p>
         * For T3 instances, you can't change the tenancy from <code>dedicated</code> to <code>host</code>, or from
         * <code>host</code> to <code>dedicated</code>. Attempting to make one of these unsupported tenancy changes
         * results in the <code>InvalidTenancy</code> error code.
         * </p>
         * </note>
         * 
         * @param tenancy
         *        The tenancy for the instance.</p> <note>
         *        <p>
         *        For T3 instances, you can't change the tenancy from <code>dedicated</code> to <code>host</code>, or
         *        from <code>host</code> to <code>dedicated</code>. Attempting to make one of these unsupported tenancy
         *        changes results in the <code>InvalidTenancy</code> error code.
         *        </p>
         * @see HostTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostTenancy
         */
        Builder tenancy(HostTenancy tenancy);

        /**
         * <p>
         * The number of the partition in which to place the instance. Valid only if the placement group strategy is set
         * to <code>partition</code>.
         * </p>
         * 
         * @param partitionNumber
         *        The number of the partition in which to place the instance. Valid only if the placement group strategy
         *        is set to <code>partition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionNumber(Integer partitionNumber);

        /**
         * <p>
         * The ARN of the host resource group in which to place the instance.
         * </p>
         * 
         * @param hostResourceGroupArn
         *        The ARN of the host resource group in which to place the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostResourceGroupArn(String hostResourceGroupArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String affinity;

        private String groupName;

        private String hostId;

        private String instanceId;

        private String tenancy;

        private Integer partitionNumber;

        private String hostResourceGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstancePlacementRequest model) {
            super(model);
            affinity(model.affinity);
            groupName(model.groupName);
            hostId(model.hostId);
            instanceId(model.instanceId);
            tenancy(model.tenancy);
            partitionNumber(model.partitionNumber);
            hostResourceGroupArn(model.hostResourceGroupArn);
        }

        public final String getAffinity() {
            return affinity;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        @Override
        @Transient
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        @Override
        @Transient
        public final Builder affinity(Affinity affinity) {
            this.affinity(affinity == null ? null : affinity.toString());
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        @Transient
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getHostId() {
            return hostId;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @Override
        @Transient
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getTenancy() {
            return tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        @Transient
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        @Transient
        public final Builder tenancy(HostTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final Integer getPartitionNumber() {
            return partitionNumber;
        }

        public final void setPartitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
        }

        @Override
        @Transient
        public final Builder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            return this;
        }

        public final String getHostResourceGroupArn() {
            return hostResourceGroupArn;
        }

        public final void setHostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
        }

        @Override
        @Transient
        public final Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstancePlacementRequest build() {
            return new ModifyInstancePlacementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
