/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceEventWindowRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyInstanceEventWindowRequest.Builder, ModifyInstanceEventWindowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(ModifyInstanceEventWindowRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> INSTANCE_EVENT_WINDOW_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceEventWindowId")
            .getter(getter(ModifyInstanceEventWindowRequest::instanceEventWindowId))
            .setter(setter(Builder::instanceEventWindowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventWindowId")
                    .unmarshallLocationName("InstanceEventWindowId").build()).build();

    private static final SdkField<List<InstanceEventWindowTimeRangeRequest>> TIME_RANGES_FIELD = SdkField
            .<List<InstanceEventWindowTimeRangeRequest>> builder(MarshallingType.LIST)
            .memberName("TimeRanges")
            .getter(getter(ModifyInstanceEventWindowRequest::timeRanges))
            .setter(setter(Builder::timeRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRange")
                    .unmarshallLocationName("TimeRange").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceEventWindowTimeRangeRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceEventWindowTimeRangeRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<String> CRON_EXPRESSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CronExpression")
            .getter(getter(ModifyInstanceEventWindowRequest::cronExpression))
            .setter(setter(Builder::cronExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CronExpression")
                    .unmarshallLocationName("CronExpression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            INSTANCE_EVENT_WINDOW_ID_FIELD, TIME_RANGES_FIELD, CRON_EXPRESSION_FIELD));

    private final String name;

    private final String instanceEventWindowId;

    private final List<InstanceEventWindowTimeRangeRequest> timeRanges;

    private final String cronExpression;

    private ModifyInstanceEventWindowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.instanceEventWindowId = builder.instanceEventWindowId;
        this.timeRanges = builder.timeRanges;
        this.cronExpression = builder.cronExpression;
    }

    /**
     * <p>
     * The name of the event window.
     * </p>
     * 
     * @return The name of the event window.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the event window.
     * </p>
     * 
     * @return The ID of the event window.
     */
    public final String instanceEventWindowId() {
        return instanceEventWindowId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TimeRanges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTimeRanges() {
        return timeRanges != null && !(timeRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The time ranges of the event window.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimeRanges} method.
     * </p>
     * 
     * @return The time ranges of the event window.
     */
    public final List<InstanceEventWindowTimeRangeRequest> timeRanges() {
        return timeRanges;
    }

    /**
     * <p>
     * The cron expression of the event window, for example, <code>* 0-4,20-23 * * 1,5</code>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Only hour and day of the week values are supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * For day of the week values, you can specify either integers <code>0</code> through <code>6</code>, or alternative
     * single values <code>SUN</code> through <code>SAT</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The minute, month, and year must be specified by <code>*</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The hour value must be one or a multiple range, for example, <code>0-4</code> or <code>0-4,20-23</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each hour range must be &gt;= 2 hours, for example, <code>0-2</code> or <code>20-23</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The event window must be &gt;= 4 hours. The combined total time ranges in the event window must be &gt;= 4 hours.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about cron expressions, see <a href="https://en.wikipedia.org/wiki/Cron">cron</a> on the
     * <i>Wikipedia website</i>.
     * </p>
     * 
     * @return The cron expression of the event window, for example, <code>* 0-4,20-23 * * 1,5</code>.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Only hour and day of the week values are supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For day of the week values, you can specify either integers <code>0</code> through <code>6</code>, or
     *         alternative single values <code>SUN</code> through <code>SAT</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The minute, month, and year must be specified by <code>*</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The hour value must be one or a multiple range, for example, <code>0-4</code> or <code>0-4,20-23</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each hour range must be &gt;= 2 hours, for example, <code>0-2</code> or <code>20-23</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The event window must be &gt;= 4 hours. The combined total time ranges in the event window must be &gt;=
     *         4 hours.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about cron expressions, see <a href="https://en.wikipedia.org/wiki/Cron">cron</a> on
     *         the <i>Wikipedia website</i>.
     */
    public final String cronExpression() {
        return cronExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(instanceEventWindowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTimeRanges() ? timeRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cronExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceEventWindowRequest)) {
            return false;
        }
        ModifyInstanceEventWindowRequest other = (ModifyInstanceEventWindowRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(instanceEventWindowId(), other.instanceEventWindowId())
                && hasTimeRanges() == other.hasTimeRanges() && Objects.equals(timeRanges(), other.timeRanges())
                && Objects.equals(cronExpression(), other.cronExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstanceEventWindowRequest").add("Name", name())
                .add("InstanceEventWindowId", instanceEventWindowId()).add("TimeRanges", hasTimeRanges() ? timeRanges() : null)
                .add("CronExpression", cronExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "InstanceEventWindowId":
            return Optional.ofNullable(clazz.cast(instanceEventWindowId()));
        case "TimeRanges":
            return Optional.ofNullable(clazz.cast(timeRanges()));
        case "CronExpression":
            return Optional.ofNullable(clazz.cast(cronExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceEventWindowRequest, T> g) {
        return obj -> g.apply((ModifyInstanceEventWindowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyInstanceEventWindowRequest> {
        /**
         * <p>
         * The name of the event window.
         * </p>
         * 
         * @param name
         *        The name of the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the event window.
         * </p>
         * 
         * @param instanceEventWindowId
         *        The ID of the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceEventWindowId(String instanceEventWindowId);

        /**
         * <p>
         * The time ranges of the event window.
         * </p>
         * 
         * @param timeRanges
         *        The time ranges of the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRanges(Collection<InstanceEventWindowTimeRangeRequest> timeRanges);

        /**
         * <p>
         * The time ranges of the event window.
         * </p>
         * 
         * @param timeRanges
         *        The time ranges of the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRanges(InstanceEventWindowTimeRangeRequest... timeRanges);

        /**
         * <p>
         * The time ranges of the event window.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <InstanceEventWindowTimeRangeRequest>.Builder} avoiding the need to create one manually via {@link List
         * <InstanceEventWindowTimeRangeRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceEventWindowTimeRangeRequest>.Builder#build()} is
         * called immediately and its result is passed to {@link #timeRanges(List<InstanceEventWindowTimeRangeRequest>)}
         * .
         * 
         * @param timeRanges
         *        a consumer that will call methods on {@link List<InstanceEventWindowTimeRangeRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRanges(List<InstanceEventWindowTimeRangeRequest>)
         */
        Builder timeRanges(Consumer<InstanceEventWindowTimeRangeRequest.Builder>... timeRanges);

        /**
         * <p>
         * The cron expression of the event window, for example, <code>* 0-4,20-23 * * 1,5</code>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Only hour and day of the week values are supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * For day of the week values, you can specify either integers <code>0</code> through <code>6</code>, or
         * alternative single values <code>SUN</code> through <code>SAT</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The minute, month, and year must be specified by <code>*</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The hour value must be one or a multiple range, for example, <code>0-4</code> or <code>0-4,20-23</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each hour range must be &gt;= 2 hours, for example, <code>0-2</code> or <code>20-23</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The event window must be &gt;= 4 hours. The combined total time ranges in the event window must be &gt;= 4
         * hours.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about cron expressions, see <a href="https://en.wikipedia.org/wiki/Cron">cron</a> on the
         * <i>Wikipedia website</i>.
         * </p>
         * 
         * @param cronExpression
         *        The cron expression of the event window, for example, <code>* 0-4,20-23 * * 1,5</code>.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Only hour and day of the week values are supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For day of the week values, you can specify either integers <code>0</code> through <code>6</code>, or
         *        alternative single values <code>SUN</code> through <code>SAT</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The minute, month, and year must be specified by <code>*</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The hour value must be one or a multiple range, for example, <code>0-4</code> or
         *        <code>0-4,20-23</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each hour range must be &gt;= 2 hours, for example, <code>0-2</code> or <code>20-23</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The event window must be &gt;= 4 hours. The combined total time ranges in the event window must be
         *        &gt;= 4 hours.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about cron expressions, see <a href="https://en.wikipedia.org/wiki/Cron">cron</a>
         *        on the <i>Wikipedia website</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cronExpression(String cronExpression);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String name;

        private String instanceEventWindowId;

        private List<InstanceEventWindowTimeRangeRequest> timeRanges = DefaultSdkAutoConstructList.getInstance();

        private String cronExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceEventWindowRequest model) {
            super(model);
            name(model.name);
            instanceEventWindowId(model.instanceEventWindowId);
            timeRanges(model.timeRanges);
            cronExpression(model.cronExpression);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInstanceEventWindowId() {
            return instanceEventWindowId;
        }

        public final void setInstanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
        }

        @Override
        @Transient
        public final Builder instanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
            return this;
        }

        public final List<InstanceEventWindowTimeRangeRequest.Builder> getTimeRanges() {
            List<InstanceEventWindowTimeRangeRequest.Builder> result = InstanceEventWindowTimeRangeRequestSetCopier
                    .copyToBuilder(this.timeRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeRanges(Collection<InstanceEventWindowTimeRangeRequest.BuilderImpl> timeRanges) {
            this.timeRanges = InstanceEventWindowTimeRangeRequestSetCopier.copyFromBuilder(timeRanges);
        }

        @Override
        @Transient
        public final Builder timeRanges(Collection<InstanceEventWindowTimeRangeRequest> timeRanges) {
            this.timeRanges = InstanceEventWindowTimeRangeRequestSetCopier.copy(timeRanges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder timeRanges(InstanceEventWindowTimeRangeRequest... timeRanges) {
            timeRanges(Arrays.asList(timeRanges));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder timeRanges(Consumer<InstanceEventWindowTimeRangeRequest.Builder>... timeRanges) {
            timeRanges(Stream.of(timeRanges).map(c -> InstanceEventWindowTimeRangeRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCronExpression() {
            return cronExpression;
        }

        public final void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        @Override
        @Transient
        public final Builder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceEventWindowRequest build() {
            return new ModifyInstanceEventWindowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
