/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more targets associated with the event window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceEventWindowAssociationTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceEventWindowAssociationTarget.Builder, InstanceEventWindowAssociationTarget> {
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceIds")
            .getter(getter(InstanceEventWindowAssociationTarget::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIdSet")
                    .unmarshallLocationName("instanceIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(InstanceEventWindowAssociationTarget::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> DEDICATED_HOST_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DedicatedHostIds")
            .getter(getter(InstanceEventWindowAssociationTarget::dedicatedHostIds))
            .setter(setter(Builder::dedicatedHostIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedHostIdSet")
                    .unmarshallLocationName("dedicatedHostIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IDS_FIELD,
            TAGS_FIELD, DEDICATED_HOST_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> instanceIds;

    private final List<Tag> tags;

    private final List<String> dedicatedHostIds;

    private InstanceEventWindowAssociationTarget(BuilderImpl builder) {
        this.instanceIds = builder.instanceIds;
        this.tags = builder.tags;
        this.dedicatedHostIds = builder.dedicatedHostIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceIds() {
        return instanceIds != null && !(instanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the instances associated with the event window.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceIds} method.
     * </p>
     * 
     * @return The IDs of the instances associated with the event window.
     */
    public final List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance tags associated with the event window. Any instances associated with the tags will be associated
     * with the event window.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The instance tags associated with the event window. Any instances associated with the tags will be
     *         associated with the event window.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the DedicatedHostIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDedicatedHostIds() {
        return dedicatedHostIds != null && !(dedicatedHostIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts associated with the event window.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDedicatedHostIds} method.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts associated with the event window.
     */
    public final List<String> dedicatedHostIds() {
        return dedicatedHostIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceIds() ? instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDedicatedHostIds() ? dedicatedHostIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceEventWindowAssociationTarget)) {
            return false;
        }
        InstanceEventWindowAssociationTarget other = (InstanceEventWindowAssociationTarget) obj;
        return hasInstanceIds() == other.hasInstanceIds() && Objects.equals(instanceIds(), other.instanceIds())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasDedicatedHostIds() == other.hasDedicatedHostIds()
                && Objects.equals(dedicatedHostIds(), other.dedicatedHostIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceEventWindowAssociationTarget")
                .add("InstanceIds", hasInstanceIds() ? instanceIds() : null).add("Tags", hasTags() ? tags() : null)
                .add("DedicatedHostIds", hasDedicatedHostIds() ? dedicatedHostIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DedicatedHostIds":
            return Optional.ofNullable(clazz.cast(dedicatedHostIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceEventWindowAssociationTarget, T> g) {
        return obj -> g.apply((InstanceEventWindowAssociationTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceEventWindowAssociationTarget> {
        /**
         * <p>
         * The IDs of the instances associated with the event window.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the instances associated with the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The IDs of the instances associated with the event window.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the instances associated with the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The instance tags associated with the event window. Any instances associated with the tags will be associated
         * with the event window.
         * </p>
         * 
         * @param tags
         *        The instance tags associated with the event window. Any instances associated with the tags will be
         *        associated with the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The instance tags associated with the event window. Any instances associated with the tags will be associated
         * with the event window.
         * </p>
         * 
         * @param tags
         *        The instance tags associated with the event window. Any instances associated with the tags will be
         *        associated with the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The instance tags associated with the event window. Any instances associated with the tags will be associated
         * with the event window.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The IDs of the Dedicated Hosts associated with the event window.
         * </p>
         * 
         * @param dedicatedHostIds
         *        The IDs of the Dedicated Hosts associated with the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedHostIds(Collection<String> dedicatedHostIds);

        /**
         * <p>
         * The IDs of the Dedicated Hosts associated with the event window.
         * </p>
         * 
         * @param dedicatedHostIds
         *        The IDs of the Dedicated Hosts associated with the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedHostIds(String... dedicatedHostIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> dedicatedHostIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceEventWindowAssociationTarget model) {
            instanceIds(model.instanceIds);
            tags(model.tags);
            dedicatedHostIds(model.dedicatedHostIds);
        }

        public final Collection<String> getInstanceIds() {
            if (instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
        }

        @Override
        @Transient
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDedicatedHostIds() {
            if (dedicatedHostIds instanceof SdkAutoConstructList) {
                return null;
            }
            return dedicatedHostIds;
        }

        public final void setDedicatedHostIds(Collection<String> dedicatedHostIds) {
            this.dedicatedHostIds = DedicatedHostIdListCopier.copy(dedicatedHostIds);
        }

        @Override
        @Transient
        public final Builder dedicatedHostIds(Collection<String> dedicatedHostIds) {
            this.dedicatedHostIds = DedicatedHostIdListCopier.copy(dedicatedHostIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dedicatedHostIds(String... dedicatedHostIds) {
            dedicatedHostIds(Arrays.asList(dedicatedHostIds));
            return this;
        }

        @Override
        public InstanceEventWindowAssociationTarget build() {
            return new InstanceEventWindowAssociationTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
