/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePrincipalIdFormatResponse extends Ec2Response implements
        ToCopyableBuilder<DescribePrincipalIdFormatResponse.Builder, DescribePrincipalIdFormatResponse> {
    private static final SdkField<List<PrincipalIdFormat>> PRINCIPALS_FIELD = SdkField
            .<List<PrincipalIdFormat>> builder(MarshallingType.LIST)
            .memberName("Principals")
            .getter(getter(DescribePrincipalIdFormatResponse::principals))
            .setter(setter(Builder::principals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalSet")
                    .unmarshallLocationName("principalSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PrincipalIdFormat> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalIdFormat::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribePrincipalIdFormatResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPALS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PrincipalIdFormat> principals;

    private final String nextToken;

    private DescribePrincipalIdFormatResponse(BuilderImpl builder) {
        super(builder);
        this.principals = builder.principals;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Principals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrincipals() {
        return principals != null && !(principals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the ID format settings for the ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipals} method.
     * </p>
     * 
     * @return Information about the ID format settings for the ARN.
     */
    public final List<PrincipalIdFormat> principals() {
        return principals;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipals() ? principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrincipalIdFormatResponse)) {
            return false;
        }
        DescribePrincipalIdFormatResponse other = (DescribePrincipalIdFormatResponse) obj;
        return hasPrincipals() == other.hasPrincipals() && Objects.equals(principals(), other.principals())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePrincipalIdFormatResponse").add("Principals", hasPrincipals() ? principals() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Principals":
            return Optional.ofNullable(clazz.cast(principals()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePrincipalIdFormatResponse, T> g) {
        return obj -> g.apply((DescribePrincipalIdFormatResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribePrincipalIdFormatResponse> {
        /**
         * <p>
         * Information about the ID format settings for the ARN.
         * </p>
         * 
         * @param principals
         *        Information about the ID format settings for the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<PrincipalIdFormat> principals);

        /**
         * <p>
         * Information about the ID format settings for the ARN.
         * </p>
         * 
         * @param principals
         *        Information about the ID format settings for the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(PrincipalIdFormat... principals);

        /**
         * <p>
         * Information about the ID format settings for the ARN.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrincipalIdFormat>.Builder} avoiding the
         * need to create one manually via {@link List<PrincipalIdFormat>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrincipalIdFormat>.Builder#build()} is called immediately
         * and its result is passed to {@link #principals(List<PrincipalIdFormat>)}.
         * 
         * @param principals
         *        a consumer that will call methods on {@link List<PrincipalIdFormat>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principals(List<PrincipalIdFormat>)
         */
        Builder principals(Consumer<PrincipalIdFormat.Builder>... principals);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<PrincipalIdFormat> principals = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrincipalIdFormatResponse model) {
            super(model);
            principals(model.principals);
            nextToken(model.nextToken);
        }

        public final List<PrincipalIdFormat.Builder> getPrincipals() {
            List<PrincipalIdFormat.Builder> result = PrincipalIdFormatListCopier.copyToBuilder(this.principals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrincipals(Collection<PrincipalIdFormat.BuilderImpl> principals) {
            this.principals = PrincipalIdFormatListCopier.copyFromBuilder(principals);
        }

        @Override
        @Transient
        public final Builder principals(Collection<PrincipalIdFormat> principals) {
            this.principals = PrincipalIdFormatListCopier.copy(principals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder principals(PrincipalIdFormat... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder principals(Consumer<PrincipalIdFormat.Builder>... principals) {
            principals(Stream.of(principals).map(c -> PrincipalIdFormat.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribePrincipalIdFormatResponse build() {
            return new DescribePrincipalIdFormatResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
