/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLocalGatewayRouteTableVpcAssociationResponse extends Ec2Response
        implements
        ToCopyableBuilder<DeleteLocalGatewayRouteTableVpcAssociationResponse.Builder, DeleteLocalGatewayRouteTableVpcAssociationResponse> {
    private static final SdkField<LocalGatewayRouteTableVpcAssociation> LOCAL_GATEWAY_ROUTE_TABLE_VPC_ASSOCIATION_FIELD = SdkField
            .<LocalGatewayRouteTableVpcAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("LocalGatewayRouteTableVpcAssociation")
            .getter(getter(DeleteLocalGatewayRouteTableVpcAssociationResponse::localGatewayRouteTableVpcAssociation))
            .setter(setter(Builder::localGatewayRouteTableVpcAssociation))
            .constructor(LocalGatewayRouteTableVpcAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayRouteTableVpcAssociation")
                    .unmarshallLocationName("localGatewayRouteTableVpcAssociation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LOCAL_GATEWAY_ROUTE_TABLE_VPC_ASSOCIATION_FIELD));

    private final LocalGatewayRouteTableVpcAssociation localGatewayRouteTableVpcAssociation;

    private DeleteLocalGatewayRouteTableVpcAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.localGatewayRouteTableVpcAssociation = builder.localGatewayRouteTableVpcAssociation;
    }

    /**
     * <p>
     * Information about the association.
     * </p>
     * 
     * @return Information about the association.
     */
    public final LocalGatewayRouteTableVpcAssociation localGatewayRouteTableVpcAssociation() {
        return localGatewayRouteTableVpcAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableVpcAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLocalGatewayRouteTableVpcAssociationResponse)) {
            return false;
        }
        DeleteLocalGatewayRouteTableVpcAssociationResponse other = (DeleteLocalGatewayRouteTableVpcAssociationResponse) obj;
        return Objects.equals(localGatewayRouteTableVpcAssociation(), other.localGatewayRouteTableVpcAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteLocalGatewayRouteTableVpcAssociationResponse")
                .add("LocalGatewayRouteTableVpcAssociation", localGatewayRouteTableVpcAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayRouteTableVpcAssociation":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableVpcAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLocalGatewayRouteTableVpcAssociationResponse, T> g) {
        return obj -> g.apply((DeleteLocalGatewayRouteTableVpcAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteLocalGatewayRouteTableVpcAssociationResponse> {
        /**
         * <p>
         * Information about the association.
         * </p>
         * 
         * @param localGatewayRouteTableVpcAssociation
         *        Information about the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableVpcAssociation(LocalGatewayRouteTableVpcAssociation localGatewayRouteTableVpcAssociation);

        /**
         * <p>
         * Information about the association.
         * </p>
         * This is a convenience that creates an instance of the {@link LocalGatewayRouteTableVpcAssociation.Builder}
         * avoiding the need to create one manually via {@link LocalGatewayRouteTableVpcAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link LocalGatewayRouteTableVpcAssociation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #localGatewayRouteTableVpcAssociation(LocalGatewayRouteTableVpcAssociation)}.
         * 
         * @param localGatewayRouteTableVpcAssociation
         *        a consumer that will call methods on {@link LocalGatewayRouteTableVpcAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localGatewayRouteTableVpcAssociation(LocalGatewayRouteTableVpcAssociation)
         */
        default Builder localGatewayRouteTableVpcAssociation(
                Consumer<LocalGatewayRouteTableVpcAssociation.Builder> localGatewayRouteTableVpcAssociation) {
            return localGatewayRouteTableVpcAssociation(LocalGatewayRouteTableVpcAssociation.builder()
                    .applyMutation(localGatewayRouteTableVpcAssociation).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private LocalGatewayRouteTableVpcAssociation localGatewayRouteTableVpcAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLocalGatewayRouteTableVpcAssociationResponse model) {
            super(model);
            localGatewayRouteTableVpcAssociation(model.localGatewayRouteTableVpcAssociation);
        }

        public final LocalGatewayRouteTableVpcAssociation.Builder getLocalGatewayRouteTableVpcAssociation() {
            return localGatewayRouteTableVpcAssociation != null ? localGatewayRouteTableVpcAssociation.toBuilder() : null;
        }

        public final void setLocalGatewayRouteTableVpcAssociation(
                LocalGatewayRouteTableVpcAssociation.BuilderImpl localGatewayRouteTableVpcAssociation) {
            this.localGatewayRouteTableVpcAssociation = localGatewayRouteTableVpcAssociation != null ? localGatewayRouteTableVpcAssociation
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder localGatewayRouteTableVpcAssociation(
                LocalGatewayRouteTableVpcAssociation localGatewayRouteTableVpcAssociation) {
            this.localGatewayRouteTableVpcAssociation = localGatewayRouteTableVpcAssociation;
            return this;
        }

        @Override
        public DeleteLocalGatewayRouteTableVpcAssociationResponse build() {
            return new DeleteLocalGatewayRouteTableVpcAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
