/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubnetRequest extends Ec2Request implements
        ToCopyableBuilder<CreateSubnetRequest.Builder, CreateSubnetRequest> {
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateSubnetRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(CreateSubnetRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("AvailabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(CreateSubnetRequest::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("AvailabilityZoneId").build()).build();

    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrBlock")
            .getter(getter(CreateSubnetRequest::cidrBlock))
            .setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock")
                    .unmarshallLocationName("CidrBlock").build()).build();

    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6CidrBlock")
            .getter(getter(CreateSubnetRequest::ipv6CidrBlock))
            .setter(setter(Builder::ipv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock")
                    .unmarshallLocationName("Ipv6CidrBlock").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(CreateSubnetRequest::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("OutpostArn").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(CreateSubnetRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("VpcId").build()).build();

    private static final SdkField<Boolean> IPV6_NATIVE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Ipv6Native")
            .getter(getter(CreateSubnetRequest::ipv6Native))
            .setter(setter(Builder::ipv6Native))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Native")
                    .unmarshallLocationName("Ipv6Native").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_SPECIFICATIONS_FIELD,
            AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CIDR_BLOCK_FIELD, IPV6_CIDR_BLOCK_FIELD, OUTPOST_ARN_FIELD,
            VPC_ID_FIELD, IPV6_NATIVE_FIELD));

    private final List<TagSpecification> tagSpecifications;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final String cidrBlock;

    private final String ipv6CidrBlock;

    private final String outpostArn;

    private final String vpcId;

    private final Boolean ipv6Native;

    private CreateSubnetRequest(BuilderImpl builder) {
        super(builder);
        this.tagSpecifications = builder.tagSpecifications;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.outpostArn = builder.outpostArn;
        this.vpcId = builder.vpcId;
        this.ipv6Native = builder.ipv6Native;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to assign to the subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to assign to the subnet.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * The Availability Zone or Local Zone for the subnet.
     * </p>
     * <p>
     * Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we do not
     * necessarily select a different zone for each subnet.
     * </p>
     * <p>
     * To create a subnet in a Local Zone, set this value to the Local Zone ID, for example
     * <code>us-west-2-lax-1a</code>. For information about the Regions that support Local Zones, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions"
     * >Available Regions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * To create a subnet in an Outpost, set this value to the Availability Zone for the Outpost and specify the Outpost
     * ARN.
     * </p>
     * 
     * @return The Availability Zone or Local Zone for the subnet.</p>
     *         <p>
     *         Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we do
     *         not necessarily select a different zone for each subnet.
     *         </p>
     *         <p>
     *         To create a subnet in a Local Zone, set this value to the Local Zone ID, for example
     *         <code>us-west-2-lax-1a</code>. For information about the Regions that support Local Zones, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions"
     *         >Available Regions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *         </p>
     *         <p>
     *         To create a subnet in an Outpost, set this value to the Availability Zone for the Outpost and specify the
     *         Outpost ARN.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The AZ ID or the Local Zone ID of the subnet.
     * </p>
     * 
     * @return The AZ ID or the Local Zone ID of the subnet.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>. We modify the
     * specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it
     * to <code>100.68.0.0/18</code>.
     * </p>
     * <p>
     * This parameter is not supported for an IPv6 only subnet.
     * </p>
     * 
     * @return The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>. We modify
     *         the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>,
     *         we modify it to <code>100.68.0.0/18</code>.</p>
     *         <p>
     *         This parameter is not supported for an IPv6 only subnet.
     */
    public final String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix length.
     * </p>
     * <p>
     * This parameter is required for an IPv6 only subnet.
     * </p>
     * 
     * @return The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix
     *         length.</p>
     *         <p>
     *         This parameter is required for an IPv6 only subnet.
     */
    public final String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also specify the
     * Availability Zone of the Outpost subnet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also specify the
     *         Availability Zone of the Outpost subnet.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Indicates whether to create an IPv6 only subnet.
     * </p>
     * 
     * @return Indicates whether to create an IPv6 only subnet.
     */
    public final Boolean ipv6Native() {
        return ipv6Native;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Native());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetRequest)) {
            return false;
        }
        CreateSubnetRequest other = (CreateSubnetRequest) obj;
        return hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(cidrBlock(), other.cidrBlock()) && Objects.equals(ipv6CidrBlock(), other.ipv6CidrBlock())
                && Objects.equals(outpostArn(), other.outpostArn()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(ipv6Native(), other.ipv6Native());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubnetRequest")
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("AvailabilityZone", availabilityZone()).add("AvailabilityZoneId", availabilityZoneId())
                .add("CidrBlock", cidrBlock()).add("Ipv6CidrBlock", ipv6CidrBlock()).add("OutpostArn", outpostArn())
                .add("VpcId", vpcId()).add("Ipv6Native", ipv6Native()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "Ipv6CidrBlock":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlock()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Ipv6Native":
            return Optional.ofNullable(clazz.cast(ipv6Native()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubnetRequest, T> g) {
        return obj -> g.apply((CreateSubnetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateSubnetRequest> {
        /**
         * <p>
         * The tags to assign to the subnet.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to assign to the subnet.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to assign to the subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * The Availability Zone or Local Zone for the subnet.
         * </p>
         * <p>
         * Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we do not
         * necessarily select a different zone for each subnet.
         * </p>
         * <p>
         * To create a subnet in a Local Zone, set this value to the Local Zone ID, for example
         * <code>us-west-2-lax-1a</code>. For information about the Regions that support Local Zones, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions"
         * >Available Regions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <p>
         * To create a subnet in an Outpost, set this value to the Availability Zone for the Outpost and specify the
         * Outpost ARN.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone or Local Zone for the subnet.</p>
         *        <p>
         *        Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we
         *        do not necessarily select a different zone for each subnet.
         *        </p>
         *        <p>
         *        To create a subnet in a Local Zone, set this value to the Local Zone ID, for example
         *        <code>us-west-2-lax-1a</code>. For information about the Regions that support Local Zones, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions"
         *        >Available Regions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         *        </p>
         *        <p>
         *        To create a subnet in an Outpost, set this value to the Availability Zone for the Outpost and specify
         *        the Outpost ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The AZ ID or the Local Zone ID of the subnet.
         * </p>
         * 
         * @param availabilityZoneId
         *        The AZ ID or the Local Zone ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>. We modify the
         * specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we
         * modify it to <code>100.68.0.0/18</code>.
         * </p>
         * <p>
         * This parameter is not supported for an IPv6 only subnet.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>. We
         *        modify the specified CIDR block to its canonical form; for example, if you specify
         *        <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
         *        <p>
         *        This parameter is not supported for an IPv6 only subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix length.
         * </p>
         * <p>
         * This parameter is required for an IPv6 only subnet.
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix
         *        length.</p>
         *        <p>
         *        This parameter is required for an IPv6 only subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also specify the
         * Availability Zone of the Outpost subnet.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also specify
         *        the Availability Zone of the Outpost subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Indicates whether to create an IPv6 only subnet.
         * </p>
         * 
         * @param ipv6Native
         *        Indicates whether to create an IPv6 only subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Native(Boolean ipv6Native);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZone;

        private String availabilityZoneId;

        private String cidrBlock;

        private String ipv6CidrBlock;

        private String outpostArn;

        private String vpcId;

        private Boolean ipv6Native;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubnetRequest model) {
            super(model);
            tagSpecifications(model.tagSpecifications);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            cidrBlock(model.cidrBlock);
            ipv6CidrBlock(model.ipv6CidrBlock);
            outpostArn(model.outpostArn);
            vpcId(model.vpcId);
            ipv6Native(model.ipv6Native);
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        @Transient
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        @Transient
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        @Transient
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        @Transient
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        @Transient
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Boolean getIpv6Native() {
            return ipv6Native;
        }

        public final void setIpv6Native(Boolean ipv6Native) {
            this.ipv6Native = ipv6Native;
        }

        @Override
        @Transient
        public final Builder ipv6Native(Boolean ipv6Native) {
            this.ipv6Native = ipv6Native;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubnetRequest build() {
            return new CreateSubnetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
