/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePublicIpv4PoolResponse extends Ec2Response implements
        ToCopyableBuilder<CreatePublicIpv4PoolResponse.Builder, CreatePublicIpv4PoolResponse> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PoolId")
            .getter(getter(CreatePublicIpv4PoolResponse::poolId))
            .setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId")
                    .unmarshallLocationName("poolId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD));

    private final String poolId;

    private CreatePublicIpv4PoolResponse(BuilderImpl builder) {
        super(builder);
        this.poolId = builder.poolId;
    }

    /**
     * <p>
     * The ID of the public IPv4 pool.
     * </p>
     * 
     * @return The ID of the public IPv4 pool.
     */
    public final String poolId() {
        return poolId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePublicIpv4PoolResponse)) {
            return false;
        }
        CreatePublicIpv4PoolResponse other = (CreatePublicIpv4PoolResponse) obj;
        return Objects.equals(poolId(), other.poolId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePublicIpv4PoolResponse").add("PoolId", poolId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePublicIpv4PoolResponse, T> g) {
        return obj -> g.apply((CreatePublicIpv4PoolResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreatePublicIpv4PoolResponse> {
        /**
         * <p>
         * The ID of the public IPv4 pool.
         * </p>
         * 
         * @param poolId
         *        The ID of the public IPv4 pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String poolId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePublicIpv4PoolResponse model) {
            super(model);
            poolId(model.poolId);
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        @Transient
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        @Override
        public CreatePublicIpv4PoolResponse build() {
            return new CreatePublicIpv4PoolResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
