/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkInsightsPathResponse extends Ec2Response implements
        ToCopyableBuilder<CreateNetworkInsightsPathResponse.Builder, CreateNetworkInsightsPathResponse> {
    private static final SdkField<NetworkInsightsPath> NETWORK_INSIGHTS_PATH_FIELD = SdkField
            .<NetworkInsightsPath> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkInsightsPath")
            .getter(getter(CreateNetworkInsightsPathResponse::networkInsightsPath))
            .setter(setter(Builder::networkInsightsPath))
            .constructor(NetworkInsightsPath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsPath")
                    .unmarshallLocationName("networkInsightsPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSIGHTS_PATH_FIELD));

    private final NetworkInsightsPath networkInsightsPath;

    private CreateNetworkInsightsPathResponse(BuilderImpl builder) {
        super(builder);
        this.networkInsightsPath = builder.networkInsightsPath;
    }

    /**
     * <p>
     * Information about the path.
     * </p>
     * 
     * @return Information about the path.
     */
    public final NetworkInsightsPath networkInsightsPath() {
        return networkInsightsPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInsightsPathResponse)) {
            return false;
        }
        CreateNetworkInsightsPathResponse other = (CreateNetworkInsightsPathResponse) obj;
        return Objects.equals(networkInsightsPath(), other.networkInsightsPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNetworkInsightsPathResponse").add("NetworkInsightsPath", networkInsightsPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsPath":
            return Optional.ofNullable(clazz.cast(networkInsightsPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkInsightsPathResponse, T> g) {
        return obj -> g.apply((CreateNetworkInsightsPathResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateNetworkInsightsPathResponse> {
        /**
         * <p>
         * Information about the path.
         * </p>
         * 
         * @param networkInsightsPath
         *        Information about the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsPath(NetworkInsightsPath networkInsightsPath);

        /**
         * <p>
         * Information about the path.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInsightsPath.Builder} avoiding the need
         * to create one manually via {@link NetworkInsightsPath#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInsightsPath.Builder#build()} is called immediately and
         * its result is passed to {@link #networkInsightsPath(NetworkInsightsPath)}.
         * 
         * @param networkInsightsPath
         *        a consumer that will call methods on {@link NetworkInsightsPath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInsightsPath(NetworkInsightsPath)
         */
        default Builder networkInsightsPath(Consumer<NetworkInsightsPath.Builder> networkInsightsPath) {
            return networkInsightsPath(NetworkInsightsPath.builder().applyMutation(networkInsightsPath).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private NetworkInsightsPath networkInsightsPath;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkInsightsPathResponse model) {
            super(model);
            networkInsightsPath(model.networkInsightsPath);
        }

        public final NetworkInsightsPath.Builder getNetworkInsightsPath() {
            return networkInsightsPath != null ? networkInsightsPath.toBuilder() : null;
        }

        public final void setNetworkInsightsPath(NetworkInsightsPath.BuilderImpl networkInsightsPath) {
            this.networkInsightsPath = networkInsightsPath != null ? networkInsightsPath.build() : null;
        }

        @Override
        @Transient
        public final Builder networkInsightsPath(NetworkInsightsPath networkInsightsPath) {
            this.networkInsightsPath = networkInsightsPath;
            return this;
        }

        @Override
        public CreateNetworkInsightsPathResponse build() {
            return new CreateNetworkInsightsPathResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
