/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum CapacityReservationInstancePlatform {
    LINUX_UNIX("Linux/UNIX"),

    RED_HAT_ENTERPRISE_LINUX("Red Hat Enterprise Linux"),

    SUSE_LINUX("SUSE Linux"),

    WINDOWS("Windows"),

    WINDOWS_WITH_SQL_SERVER("Windows with SQL Server"),

    WINDOWS_WITH_SQL_SERVER_ENTERPRISE("Windows with SQL Server Enterprise"),

    WINDOWS_WITH_SQL_SERVER_STANDARD("Windows with SQL Server Standard"),

    WINDOWS_WITH_SQL_SERVER_WEB("Windows with SQL Server Web"),

    LINUX_WITH_SQL_SERVER_STANDARD("Linux with SQL Server Standard"),

    LINUX_WITH_SQL_SERVER_WEB("Linux with SQL Server Web"),

    LINUX_WITH_SQL_SERVER_ENTERPRISE("Linux with SQL Server Enterprise"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CapacityReservationInstancePlatform> VALUE_MAP = EnumUtils.uniqueIndex(
            CapacityReservationInstancePlatform.class, CapacityReservationInstancePlatform::toString);

    private final String value;

    private CapacityReservationInstancePlatform(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CapacityReservationInstancePlatform corresponding to the value
     */
    public static CapacityReservationInstancePlatform fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CapacityReservationInstancePlatform}s
     */
    public static Set<CapacityReservationInstancePlatform> knownValues() {
        Set<CapacityReservationInstancePlatform> knownValues = EnumSet.allOf(CapacityReservationInstancePlatform.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
