/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateEnclaveCertificateIamRoleResponse extends Ec2Response implements
        ToCopyableBuilder<AssociateEnclaveCertificateIamRoleResponse.Builder, AssociateEnclaveCertificateIamRoleResponse> {
    private static final SdkField<String> CERTIFICATE_S3_BUCKET_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateS3BucketName")
            .getter(getter(AssociateEnclaveCertificateIamRoleResponse::certificateS3BucketName))
            .setter(setter(Builder::certificateS3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateS3BucketName")
                    .unmarshallLocationName("certificateS3BucketName").build()).build();

    private static final SdkField<String> CERTIFICATE_S3_OBJECT_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateS3ObjectKey")
            .getter(getter(AssociateEnclaveCertificateIamRoleResponse::certificateS3ObjectKey))
            .setter(setter(Builder::certificateS3ObjectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateS3ObjectKey")
                    .unmarshallLocationName("certificateS3ObjectKey").build()).build();

    private static final SdkField<String> ENCRYPTION_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKmsKeyId")
            .getter(getter(AssociateEnclaveCertificateIamRoleResponse::encryptionKmsKeyId))
            .setter(setter(Builder::encryptionKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKmsKeyId")
                    .unmarshallLocationName("encryptionKmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_S3_BUCKET_NAME_FIELD, CERTIFICATE_S3_OBJECT_KEY_FIELD, ENCRYPTION_KMS_KEY_ID_FIELD));

    private final String certificateS3BucketName;

    private final String certificateS3ObjectKey;

    private final String encryptionKmsKeyId;

    private AssociateEnclaveCertificateIamRoleResponse(BuilderImpl builder) {
        super(builder);
        this.certificateS3BucketName = builder.certificateS3BucketName;
        this.certificateS3ObjectKey = builder.certificateS3ObjectKey;
        this.encryptionKmsKeyId = builder.encryptionKmsKeyId;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket to which the certificate was uploaded.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket to which the certificate was uploaded.
     */
    public final String certificateS3BucketName() {
        return certificateS3BucketName;
    }

    /**
     * <p>
     * The Amazon S3 object key where the certificate, certificate chain, and encrypted private key bundle are stored.
     * The object key is formatted as follows: <code>role_arn</code>/<code>certificate_arn</code>.
     * </p>
     * 
     * @return The Amazon S3 object key where the certificate, certificate chain, and encrypted private key bundle are
     *         stored. The object key is formatted as follows: <code>role_arn</code>/<code>certificate_arn</code>.
     */
    public final String certificateS3ObjectKey() {
        return certificateS3ObjectKey;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt the private key of the certificate.
     * </p>
     * 
     * @return The ID of the KMS key used to encrypt the private key of the certificate.
     */
    public final String encryptionKmsKeyId() {
        return encryptionKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateS3ObjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateEnclaveCertificateIamRoleResponse)) {
            return false;
        }
        AssociateEnclaveCertificateIamRoleResponse other = (AssociateEnclaveCertificateIamRoleResponse) obj;
        return Objects.equals(certificateS3BucketName(), other.certificateS3BucketName())
                && Objects.equals(certificateS3ObjectKey(), other.certificateS3ObjectKey())
                && Objects.equals(encryptionKmsKeyId(), other.encryptionKmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateEnclaveCertificateIamRoleResponse")
                .add("CertificateS3BucketName", certificateS3BucketName())
                .add("CertificateS3ObjectKey", certificateS3ObjectKey()).add("EncryptionKmsKeyId", encryptionKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateS3BucketName":
            return Optional.ofNullable(clazz.cast(certificateS3BucketName()));
        case "CertificateS3ObjectKey":
            return Optional.ofNullable(clazz.cast(certificateS3ObjectKey()));
        case "EncryptionKmsKeyId":
            return Optional.ofNullable(clazz.cast(encryptionKmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateEnclaveCertificateIamRoleResponse, T> g) {
        return obj -> g.apply((AssociateEnclaveCertificateIamRoleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateEnclaveCertificateIamRoleResponse> {
        /**
         * <p>
         * The name of the Amazon S3 bucket to which the certificate was uploaded.
         * </p>
         * 
         * @param certificateS3BucketName
         *        The name of the Amazon S3 bucket to which the certificate was uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateS3BucketName(String certificateS3BucketName);

        /**
         * <p>
         * The Amazon S3 object key where the certificate, certificate chain, and encrypted private key bundle are
         * stored. The object key is formatted as follows: <code>role_arn</code>/<code>certificate_arn</code>.
         * </p>
         * 
         * @param certificateS3ObjectKey
         *        The Amazon S3 object key where the certificate, certificate chain, and encrypted private key bundle
         *        are stored. The object key is formatted as follows: <code>role_arn</code>/<code>certificate_arn</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateS3ObjectKey(String certificateS3ObjectKey);

        /**
         * <p>
         * The ID of the KMS key used to encrypt the private key of the certificate.
         * </p>
         * 
         * @param encryptionKmsKeyId
         *        The ID of the KMS key used to encrypt the private key of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKmsKeyId(String encryptionKmsKeyId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String certificateS3BucketName;

        private String certificateS3ObjectKey;

        private String encryptionKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateEnclaveCertificateIamRoleResponse model) {
            super(model);
            certificateS3BucketName(model.certificateS3BucketName);
            certificateS3ObjectKey(model.certificateS3ObjectKey);
            encryptionKmsKeyId(model.encryptionKmsKeyId);
        }

        public final String getCertificateS3BucketName() {
            return certificateS3BucketName;
        }

        public final void setCertificateS3BucketName(String certificateS3BucketName) {
            this.certificateS3BucketName = certificateS3BucketName;
        }

        @Override
        @Transient
        public final Builder certificateS3BucketName(String certificateS3BucketName) {
            this.certificateS3BucketName = certificateS3BucketName;
            return this;
        }

        public final String getCertificateS3ObjectKey() {
            return certificateS3ObjectKey;
        }

        public final void setCertificateS3ObjectKey(String certificateS3ObjectKey) {
            this.certificateS3ObjectKey = certificateS3ObjectKey;
        }

        @Override
        @Transient
        public final Builder certificateS3ObjectKey(String certificateS3ObjectKey) {
            this.certificateS3ObjectKey = certificateS3ObjectKey;
            return this;
        }

        public final String getEncryptionKmsKeyId() {
            return encryptionKmsKeyId;
        }

        public final void setEncryptionKmsKeyId(String encryptionKmsKeyId) {
            this.encryptionKmsKeyId = encryptionKmsKeyId;
        }

        @Override
        @Transient
        public final Builder encryptionKmsKeyId(String encryptionKmsKeyId) {
            this.encryptionKmsKeyId = encryptionKmsKeyId;
            return this;
        }

        @Override
        public AssociateEnclaveCertificateIamRoleResponse build() {
            return new AssociateEnclaveCertificateIamRoleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
