/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportImageRequest extends Ec2Request implements
        ToCopyableBuilder<ImportImageRequest.Builder, ImportImageRequest> {
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Architecture")
            .getter(getter(ImportImageRequest::architecture))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture")
                    .unmarshallLocationName("Architecture").build()).build();

    private static final SdkField<ClientData> CLIENT_DATA_FIELD = SdkField
            .<ClientData> builder(MarshallingType.SDK_POJO)
            .memberName("ClientData")
            .getter(getter(ImportImageRequest::clientData))
            .setter(setter(Builder::clientData))
            .constructor(ClientData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientData")
                    .unmarshallLocationName("ClientData").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ImportImageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ImportImageRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<List<ImageDiskContainer>> DISK_CONTAINERS_FIELD = SdkField
            .<List<ImageDiskContainer>> builder(MarshallingType.LIST)
            .memberName("DiskContainers")
            .getter(getter(ImportImageRequest::diskContainers))
            .setter(setter(Builder::diskContainers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskContainer")
                    .unmarshallLocationName("DiskContainer").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ImageDiskContainer> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageDiskContainer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted")
            .getter(getter(ImportImageRequest::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted")
                    .unmarshallLocationName("Encrypted").build()).build();

    private static final SdkField<String> HYPERVISOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Hypervisor")
            .getter(getter(ImportImageRequest::hypervisor))
            .setter(setter(Builder::hypervisor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisor")
                    .unmarshallLocationName("Hypervisor").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId")
            .getter(getter(ImportImageRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId")
                    .unmarshallLocationName("KmsKeyId").build()).build();

    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LicenseType")
            .getter(getter(ImportImageRequest::licenseType))
            .setter(setter(Builder::licenseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType")
                    .unmarshallLocationName("LicenseType").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Platform")
            .getter(getter(ImportImageRequest::platform))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform")
                    .unmarshallLocationName("Platform").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RoleName")
            .getter(getter(ImportImageRequest::roleName))
            .setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName")
                    .unmarshallLocationName("RoleName").build()).build();

    private static final SdkField<List<ImportImageLicenseConfigurationRequest>> LICENSE_SPECIFICATIONS_FIELD = SdkField
            .<List<ImportImageLicenseConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("LicenseSpecifications")
            .getter(getter(ImportImageRequest::licenseSpecifications))
            .setter(setter(Builder::licenseSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecifications")
                    .unmarshallLocationName("LicenseSpecifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ImportImageLicenseConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportImageLicenseConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(ImportImageRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> USAGE_OPERATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UsageOperation")
            .getter(getter(ImportImageRequest::usageOperation))
            .setter(setter(Builder::usageOperation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperation")
                    .unmarshallLocationName("UsageOperation").build()).build();

    private static final SdkField<String> BOOT_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BootMode")
            .getter(getter(ImportImageRequest::bootModeAsString))
            .setter(setter(Builder::bootMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootMode")
                    .unmarshallLocationName("BootMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_FIELD,
            CLIENT_DATA_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DISK_CONTAINERS_FIELD, ENCRYPTED_FIELD, HYPERVISOR_FIELD,
            KMS_KEY_ID_FIELD, LICENSE_TYPE_FIELD, PLATFORM_FIELD, ROLE_NAME_FIELD, LICENSE_SPECIFICATIONS_FIELD,
            TAG_SPECIFICATIONS_FIELD, USAGE_OPERATION_FIELD, BOOT_MODE_FIELD));

    private final String architecture;

    private final ClientData clientData;

    private final String clientToken;

    private final String description;

    private final List<ImageDiskContainer> diskContainers;

    private final Boolean encrypted;

    private final String hypervisor;

    private final String kmsKeyId;

    private final String licenseType;

    private final String platform;

    private final String roleName;

    private final List<ImportImageLicenseConfigurationRequest> licenseSpecifications;

    private final List<TagSpecification> tagSpecifications;

    private final String usageOperation;

    private final String bootMode;

    private ImportImageRequest(BuilderImpl builder) {
        super(builder);
        this.architecture = builder.architecture;
        this.clientData = builder.clientData;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.diskContainers = builder.diskContainers;
        this.encrypted = builder.encrypted;
        this.hypervisor = builder.hypervisor;
        this.kmsKeyId = builder.kmsKeyId;
        this.licenseType = builder.licenseType;
        this.platform = builder.platform;
        this.roleName = builder.roleName;
        this.licenseSpecifications = builder.licenseSpecifications;
        this.tagSpecifications = builder.tagSpecifications;
        this.usageOperation = builder.usageOperation;
        this.bootMode = builder.bootMode;
    }

    /**
     * <p>
     * The architecture of the virtual machine.
     * </p>
     * <p>
     * Valid values: <code>i386</code> | <code>x86_64</code>
     * </p>
     * 
     * @return The architecture of the virtual machine.</p>
     *         <p>
     *         Valid values: <code>i386</code> | <code>x86_64</code>
     */
    public final String architecture() {
        return architecture;
    }

    /**
     * <p>
     * The client-specific data.
     * </p>
     * 
     * @return The client-specific data.
     */
    public final ClientData clientData() {
        return clientData;
    }

    /**
     * <p>
     * The token to enable idempotency for VM import requests.
     * </p>
     * 
     * @return The token to enable idempotency for VM import requests.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A description string for the import image task.
     * </p>
     * 
     * @return A description string for the import image task.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the DiskContainers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDiskContainers() {
        return diskContainers != null && !(diskContainers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the disk containers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDiskContainers} method.
     * </p>
     * 
     * @return Information about the disk containers.
     */
    public final List<ImageDiskContainer> diskContainers() {
        return diskContainers;
    }

    /**
     * <p>
     * Specifies whether the destination AMI of the imported image should be encrypted. The default KMS key for EBS is
     * used unless you specify a non-default KMS key using <code>KmsKeyId</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Specifies whether the destination AMI of the imported image should be encrypted. The default KMS key for
     *         EBS is used unless you specify a non-default KMS key using <code>KmsKeyId</code>. For more information,
     *         see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS
     *         Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The target hypervisor platform.
     * </p>
     * <p>
     * Valid values: <code>xen</code>
     * </p>
     * 
     * @return The target hypervisor platform.</p>
     *         <p>
     *         Valid values: <code>xen</code>
     */
    public final String hypervisor() {
        return hypervisor;
    }

    /**
     * <p>
     * An identifier for the symmetric KMS key to use when creating the encrypted AMI. This parameter is only required
     * if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key for EBS is
     * used. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set.
     * </p>
     * <p>
     * The KMS key identifier may be provided in any of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the key, the
     * Amazon Web Services account ID of the key owner, the <code>alias</code> namespace, and then the key alias. For
     * example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the key,
     * the Amazon Web Services account ID of the key owner, the <code>key</code> namespace, and then the key ID. For
     * example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the
     * key, the Amazon Web Services account ID of the key owner, the <code>alias</code> namespace, and then the key
     * alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Amazon Web Services parses <code>KmsKeyId</code> asynchronously, meaning that the action you call may appear to
     * complete even though you provided an invalid identifier. This action will eventually report failure.
     * </p>
     * <p>
     * The specified KMS key must exist in the Region that the AMI is being copied to.
     * </p>
     * <p>
     * Amazon EBS does not support asymmetric KMS keys.
     * </p>
     * 
     * @return An identifier for the symmetric KMS key to use when creating the encrypted AMI. This parameter is only
     *         required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS
     *         key for EBS is used. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also
     *         be set. </p>
     *         <p>
     *         The KMS key identifier may be provided in any of the following formats:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the
     *         key, the Amazon Web Services account ID of the key owner, the <code>alias</code> namespace, and then the
     *         key alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of
     *         the key, the Amazon Web Services account ID of the key owner, the <code>key</code> namespace, and then
     *         the key ID. For example,
     *         arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the
     *         Region of the key, the Amazon Web Services account ID of the key owner, the <code>alias</code> namespace,
     *         and then the key alias. For example,
     *         arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Amazon Web Services parses <code>KmsKeyId</code> asynchronously, meaning that the action you call may
     *         appear to complete even though you provided an invalid identifier. This action will eventually report
     *         failure.
     *         </p>
     *         <p>
     *         The specified KMS key must exist in the Region that the AMI is being copied to.
     *         </p>
     *         <p>
     *         Amazon EBS does not support asymmetric KMS keys.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The license type to be used for the Amazon Machine Image (AMI) after importing.
     * </p>
     * <p>
     * Specify <code>AWS</code> to replace the source-system license with an Amazon Web Services license or
     * <code>BYOL</code> to retain the source-system license. Leaving this parameter undefined is the same as choosing
     * <code>AWS</code> when importing a Windows Server operating system, and the same as choosing <code>BYOL</code>
     * when importing a Windows client operating system (such as Windows 10) or a Linux operating system.
     * </p>
     * <p>
     * To use <code>BYOL</code>, you must have existing licenses with rights to use these licenses in a third party
     * cloud, such as Amazon Web Services. For more information, see <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image"
     * >Prerequisites</a> in the VM Import/Export User Guide.
     * </p>
     * 
     * @return The license type to be used for the Amazon Machine Image (AMI) after importing.</p>
     *         <p>
     *         Specify <code>AWS</code> to replace the source-system license with an Amazon Web Services license or
     *         <code>BYOL</code> to retain the source-system license. Leaving this parameter undefined is the same as
     *         choosing <code>AWS</code> when importing a Windows Server operating system, and the same as choosing
     *         <code>BYOL</code> when importing a Windows client operating system (such as Windows 10) or a Linux
     *         operating system.
     *         </p>
     *         <p>
     *         To use <code>BYOL</code>, you must have existing licenses with rights to use these licenses in a third
     *         party cloud, such as Amazon Web Services. For more information, see <a href=
     *         "https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image"
     *         >Prerequisites</a> in the VM Import/Export User Guide.
     */
    public final String licenseType() {
        return licenseType;
    }

    /**
     * <p>
     * The operating system of the virtual machine.
     * </p>
     * <p>
     * Valid values: <code>Windows</code> | <code>Linux</code>
     * </p>
     * 
     * @return The operating system of the virtual machine.</p>
     *         <p>
     *         Valid values: <code>Windows</code> | <code>Linux</code>
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The name of the role to use when not using the default role, 'vmimport'.
     * </p>
     * 
     * @return The name of the role to use when not using the default role, 'vmimport'.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLicenseSpecifications() {
        return licenseSpecifications != null && !(licenseSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the license configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseSpecifications} method.
     * </p>
     * 
     * @return The ARNs of the license configurations.
     */
    public final List<ImportImageLicenseConfigurationRequest> licenseSpecifications() {
        return licenseSpecifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the import image task during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the import image task during creation.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * The usage operation value. For more information, see <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#prerequisites">Licensing
     * options</a> in the <i>VM Import/Export User Guide</i>.
     * </p>
     * 
     * @return The usage operation value. For more information, see <a
     *         href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#prerequisites">Licensing
     *         options</a> in the <i>VM Import/Export User Guide</i>.
     */
    public final String usageOperation() {
        return usageOperation;
    }

    /**
     * <p>
     * The boot mode of the virtual machine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootModeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return The boot mode of the virtual machine.
     * @see BootModeValues
     */
    public final BootModeValues bootMode() {
        return BootModeValues.fromValue(bootMode);
    }

    /**
     * <p>
     * The boot mode of the virtual machine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootModeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return The boot mode of the virtual machine.
     * @see BootModeValues
     */
    public final String bootModeAsString() {
        return bootMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        hashCode = 31 * hashCode + Objects.hashCode(clientData());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasDiskContainers() ? diskContainers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisor());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(licenseType());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseSpecifications() ? licenseSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(usageOperation());
        hashCode = 31 * hashCode + Objects.hashCode(bootModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageRequest)) {
            return false;
        }
        ImportImageRequest other = (ImportImageRequest) obj;
        return Objects.equals(architecture(), other.architecture()) && Objects.equals(clientData(), other.clientData())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && hasDiskContainers() == other.hasDiskContainers() && Objects.equals(diskContainers(), other.diskContainers())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(hypervisor(), other.hypervisor())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(licenseType(), other.licenseType())
                && Objects.equals(platform(), other.platform()) && Objects.equals(roleName(), other.roleName())
                && hasLicenseSpecifications() == other.hasLicenseSpecifications()
                && Objects.equals(licenseSpecifications(), other.licenseSpecifications())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(usageOperation(), other.usageOperation())
                && Objects.equals(bootModeAsString(), other.bootModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportImageRequest").add("Architecture", architecture()).add("ClientData", clientData())
                .add("ClientToken", clientToken()).add("Description", description())
                .add("DiskContainers", hasDiskContainers() ? diskContainers() : null).add("Encrypted", encrypted())
                .add("Hypervisor", hypervisor()).add("KmsKeyId", kmsKeyId()).add("LicenseType", licenseType())
                .add("Platform", platform()).add("RoleName", roleName())
                .add("LicenseSpecifications", hasLicenseSpecifications() ? licenseSpecifications() : null)
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("UsageOperation", usageOperation()).add("BootMode", bootModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architecture()));
        case "ClientData":
            return Optional.ofNullable(clazz.cast(clientData()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DiskContainers":
            return Optional.ofNullable(clazz.cast(diskContainers()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "Hypervisor":
            return Optional.ofNullable(clazz.cast(hypervisor()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "LicenseType":
            return Optional.ofNullable(clazz.cast(licenseType()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "LicenseSpecifications":
            return Optional.ofNullable(clazz.cast(licenseSpecifications()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "UsageOperation":
            return Optional.ofNullable(clazz.cast(usageOperation()));
        case "BootMode":
            return Optional.ofNullable(clazz.cast(bootModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportImageRequest, T> g) {
        return obj -> g.apply((ImportImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ImportImageRequest> {
        /**
         * <p>
         * The architecture of the virtual machine.
         * </p>
         * <p>
         * Valid values: <code>i386</code> | <code>x86_64</code>
         * </p>
         * 
         * @param architecture
         *        The architecture of the virtual machine.</p>
         *        <p>
         *        Valid values: <code>i386</code> | <code>x86_64</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The client-specific data.
         * </p>
         * 
         * @param clientData
         *        The client-specific data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientData(ClientData clientData);

        /**
         * <p>
         * The client-specific data.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientData.Builder} avoiding the need to
         * create one manually via {@link ClientData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientData.Builder#build()} is called immediately and its result
         * is passed to {@link #clientData(ClientData)}.
         * 
         * @param clientData
         *        a consumer that will call methods on {@link ClientData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientData(ClientData)
         */
        default Builder clientData(Consumer<ClientData.Builder> clientData) {
            return clientData(ClientData.builder().applyMutation(clientData).build());
        }

        /**
         * <p>
         * The token to enable idempotency for VM import requests.
         * </p>
         * 
         * @param clientToken
         *        The token to enable idempotency for VM import requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A description string for the import image task.
         * </p>
         * 
         * @param description
         *        A description string for the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the disk containers.
         * </p>
         * 
         * @param diskContainers
         *        Information about the disk containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskContainers(Collection<ImageDiskContainer> diskContainers);

        /**
         * <p>
         * Information about the disk containers.
         * </p>
         * 
         * @param diskContainers
         *        Information about the disk containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskContainers(ImageDiskContainer... diskContainers);

        /**
         * <p>
         * Information about the disk containers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ImageDiskContainer.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ImageDiskContainer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ImageDiskContainer.Builder#build()} is called immediately
         * and its result is passed to {@link #diskContainers(List<ImageDiskContainer>)}.
         * 
         * @param diskContainers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ImageDiskContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskContainers(java.util.Collection<ImageDiskContainer>)
         */
        Builder diskContainers(Consumer<ImageDiskContainer.Builder>... diskContainers);

        /**
         * <p>
         * Specifies whether the destination AMI of the imported image should be encrypted. The default KMS key for EBS
         * is used unless you specify a non-default KMS key using <code>KmsKeyId</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in
         * the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param encrypted
         *        Specifies whether the destination AMI of the imported image should be encrypted. The default KMS key
         *        for EBS is used unless you specify a non-default KMS key using <code>KmsKeyId</code>. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS
         *        Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The target hypervisor platform.
         * </p>
         * <p>
         * Valid values: <code>xen</code>
         * </p>
         * 
         * @param hypervisor
         *        The target hypervisor platform.</p>
         *        <p>
         *        Valid values: <code>xen</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * An identifier for the symmetric KMS key to use when creating the encrypted AMI. This parameter is only
         * required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key
         * for EBS is used. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set.
         * </p>
         * <p>
         * The KMS key identifier may be provided in any of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID
         * </p>
         * </li>
         * <li>
         * <p>
         * Key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the key,
         * the Amazon Web Services account ID of the key owner, the <code>alias</code> namespace, and then the key
         * alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the
         * key, the Amazon Web Services account ID of the key owner, the <code>key</code> namespace, and then the key
         * ID. For example,
         * arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of
         * the key, the Amazon Web Services account ID of the key owner, the <code>alias</code> namespace, and then the
         * key alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Amazon Web Services parses <code>KmsKeyId</code> asynchronously, meaning that the action you call may appear
         * to complete even though you provided an invalid identifier. This action will eventually report failure.
         * </p>
         * <p>
         * The specified KMS key must exist in the Region that the AMI is being copied to.
         * </p>
         * <p>
         * Amazon EBS does not support asymmetric KMS keys.
         * </p>
         * 
         * @param kmsKeyId
         *        An identifier for the symmetric KMS key to use when creating the encrypted AMI. This parameter is only
         *        required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS
         *        key for EBS is used. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must
         *        also be set. </p>
         *        <p>
         *        The KMS key identifier may be provided in any of the following formats:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of
         *        the key, the Amazon Web Services account ID of the key owner, the <code>alias</code> namespace, and
         *        then the key alias. For example,
         *        arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region
         *        of the key, the Amazon Web Services account ID of the key owner, the <code>key</code> namespace, and
         *        then the key ID. For example,
         *        arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the
         *        Region of the key, the Amazon Web Services account ID of the key owner, the <code>alias</code>
         *        namespace, and then the key alias. For example,
         *        arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Amazon Web Services parses <code>KmsKeyId</code> asynchronously, meaning that the action you call may
         *        appear to complete even though you provided an invalid identifier. This action will eventually report
         *        failure.
         *        </p>
         *        <p>
         *        The specified KMS key must exist in the Region that the AMI is being copied to.
         *        </p>
         *        <p>
         *        Amazon EBS does not support asymmetric KMS keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The license type to be used for the Amazon Machine Image (AMI) after importing.
         * </p>
         * <p>
         * Specify <code>AWS</code> to replace the source-system license with an Amazon Web Services license or
         * <code>BYOL</code> to retain the source-system license. Leaving this parameter undefined is the same as
         * choosing <code>AWS</code> when importing a Windows Server operating system, and the same as choosing
         * <code>BYOL</code> when importing a Windows client operating system (such as Windows 10) or a Linux operating
         * system.
         * </p>
         * <p>
         * To use <code>BYOL</code>, you must have existing licenses with rights to use these licenses in a third party
         * cloud, such as Amazon Web Services. For more information, see <a href=
         * "https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image"
         * >Prerequisites</a> in the VM Import/Export User Guide.
         * </p>
         * 
         * @param licenseType
         *        The license type to be used for the Amazon Machine Image (AMI) after importing.</p>
         *        <p>
         *        Specify <code>AWS</code> to replace the source-system license with an Amazon Web Services license or
         *        <code>BYOL</code> to retain the source-system license. Leaving this parameter undefined is the same as
         *        choosing <code>AWS</code> when importing a Windows Server operating system, and the same as choosing
         *        <code>BYOL</code> when importing a Windows client operating system (such as Windows 10) or a Linux
         *        operating system.
         *        </p>
         *        <p>
         *        To use <code>BYOL</code>, you must have existing licenses with rights to use these licenses in a third
         *        party cloud, such as Amazon Web Services. For more information, see <a href=
         *        "https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image"
         *        >Prerequisites</a> in the VM Import/Export User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The operating system of the virtual machine.
         * </p>
         * <p>
         * Valid values: <code>Windows</code> | <code>Linux</code>
         * </p>
         * 
         * @param platform
         *        The operating system of the virtual machine.</p>
         *        <p>
         *        Valid values: <code>Windows</code> | <code>Linux</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The name of the role to use when not using the default role, 'vmimport'.
         * </p>
         * 
         * @param roleName
         *        The name of the role to use when not using the default role, 'vmimport'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The ARNs of the license configurations.
         * </p>
         * 
         * @param licenseSpecifications
         *        The ARNs of the license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(Collection<ImportImageLicenseConfigurationRequest> licenseSpecifications);

        /**
         * <p>
         * The ARNs of the license configurations.
         * </p>
         * 
         * @param licenseSpecifications
         *        The ARNs of the license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(ImportImageLicenseConfigurationRequest... licenseSpecifications);

        /**
         * <p>
         * The ARNs of the license configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationRequest.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #licenseSpecifications(List<ImportImageLicenseConfigurationRequest>)}.
         * 
         * @param licenseSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseSpecifications(java.util.Collection<ImportImageLicenseConfigurationRequest>)
         */
        Builder licenseSpecifications(Consumer<ImportImageLicenseConfigurationRequest.Builder>... licenseSpecifications);

        /**
         * <p>
         * The tags to apply to the import image task during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the import image task during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the import image task during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the import image task during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the import image task during creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * The usage operation value. For more information, see <a
         * href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#prerequisites">Licensing
         * options</a> in the <i>VM Import/Export User Guide</i>.
         * </p>
         * 
         * @param usageOperation
         *        The usage operation value. For more information, see <a
         *        href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#prerequisites"
         *        >Licensing options</a> in the <i>VM Import/Export User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageOperation(String usageOperation);

        /**
         * <p>
         * The boot mode of the virtual machine.
         * </p>
         * 
         * @param bootMode
         *        The boot mode of the virtual machine.
         * @see BootModeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootModeValues
         */
        Builder bootMode(String bootMode);

        /**
         * <p>
         * The boot mode of the virtual machine.
         * </p>
         * 
         * @param bootMode
         *        The boot mode of the virtual machine.
         * @see BootModeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootModeValues
         */
        Builder bootMode(BootModeValues bootMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String architecture;

        private ClientData clientData;

        private String clientToken;

        private String description;

        private List<ImageDiskContainer> diskContainers = DefaultSdkAutoConstructList.getInstance();

        private Boolean encrypted;

        private String hypervisor;

        private String kmsKeyId;

        private String licenseType;

        private String platform;

        private String roleName;

        private List<ImportImageLicenseConfigurationRequest> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String usageOperation;

        private String bootMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportImageRequest model) {
            super(model);
            architecture(model.architecture);
            clientData(model.clientData);
            clientToken(model.clientToken);
            description(model.description);
            diskContainers(model.diskContainers);
            encrypted(model.encrypted);
            hypervisor(model.hypervisor);
            kmsKeyId(model.kmsKeyId);
            licenseType(model.licenseType);
            platform(model.platform);
            roleName(model.roleName);
            licenseSpecifications(model.licenseSpecifications);
            tagSpecifications(model.tagSpecifications);
            usageOperation(model.usageOperation);
            bootMode(model.bootMode);
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final ClientData.Builder getClientData() {
            return clientData != null ? clientData.toBuilder() : null;
        }

        public final void setClientData(ClientData.BuilderImpl clientData) {
            this.clientData = clientData != null ? clientData.build() : null;
        }

        @Override
        public final Builder clientData(ClientData clientData) {
            this.clientData = clientData;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ImageDiskContainer.Builder> getDiskContainers() {
            List<ImageDiskContainer.Builder> result = ImageDiskContainerListCopier.copyToBuilder(this.diskContainers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDiskContainers(Collection<ImageDiskContainer.BuilderImpl> diskContainers) {
            this.diskContainers = ImageDiskContainerListCopier.copyFromBuilder(diskContainers);
        }

        @Override
        public final Builder diskContainers(Collection<ImageDiskContainer> diskContainers) {
            this.diskContainers = ImageDiskContainerListCopier.copy(diskContainers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskContainers(ImageDiskContainer... diskContainers) {
            diskContainers(Arrays.asList(diskContainers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskContainers(Consumer<ImageDiskContainer.Builder>... diskContainers) {
            diskContainers(Stream.of(diskContainers).map(c -> ImageDiskContainer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getHypervisor() {
            return hypervisor;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final List<ImportImageLicenseConfigurationRequest.Builder> getLicenseSpecifications() {
            List<ImportImageLicenseConfigurationRequest.Builder> result = ImportImageLicenseSpecificationListRequestCopier
                    .copyToBuilder(this.licenseSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseSpecifications(
                Collection<ImportImageLicenseConfigurationRequest.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = ImportImageLicenseSpecificationListRequestCopier.copyFromBuilder(licenseSpecifications);
        }

        @Override
        public final Builder licenseSpecifications(Collection<ImportImageLicenseConfigurationRequest> licenseSpecifications) {
            this.licenseSpecifications = ImportImageLicenseSpecificationListRequestCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(ImportImageLicenseConfigurationRequest... licenseSpecifications) {
            licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(
                Consumer<ImportImageLicenseConfigurationRequest.Builder>... licenseSpecifications) {
            licenseSpecifications(Stream.of(licenseSpecifications)
                    .map(c -> ImportImageLicenseConfigurationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUsageOperation() {
            return usageOperation;
        }

        public final void setUsageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
        }

        @Override
        public final Builder usageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
            return this;
        }

        public final String getBootMode() {
            return bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootModeValues bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportImageRequest build() {
            return new ImportImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
