/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllocateIpamPoolCidrRequest extends Ec2Request implements
        ToCopyableBuilder<AllocateIpamPoolCidrRequest.Builder, AllocateIpamPoolCidrRequest> {
    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPoolId")
            .getter(getter(AllocateIpamPoolCidrRequest::ipamPoolId))
            .setter(setter(Builder::ipamPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId")
                    .unmarshallLocationName("IpamPoolId").build()).build();

    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(AllocateIpamPoolCidrRequest::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("Cidr").build()).build();

    private static final SdkField<Integer> NETMASK_LENGTH_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetmaskLength")
            .getter(getter(AllocateIpamPoolCidrRequest::netmaskLength))
            .setter(setter(Builder::netmaskLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetmaskLength")
                    .unmarshallLocationName("NetmaskLength").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(AllocateIpamPoolCidrRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(AllocateIpamPoolCidrRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<Boolean> PREVIEW_NEXT_CIDR_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PreviewNextCidr")
            .getter(getter(AllocateIpamPoolCidrRequest::previewNextCidr))
            .setter(setter(Builder::previewNextCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviewNextCidr")
                    .unmarshallLocationName("PreviewNextCidr").build()).build();

    private static final SdkField<List<String>> DISALLOWED_CIDRS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DisallowedCidrs")
            .getter(getter(AllocateIpamPoolCidrRequest::disallowedCidrs))
            .setter(setter(Builder::disallowedCidrs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisallowedCidr")
                    .unmarshallLocationName("DisallowedCidr").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POOL_ID_FIELD,
            CIDR_FIELD, NETMASK_LENGTH_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, PREVIEW_NEXT_CIDR_FIELD,
            DISALLOWED_CIDRS_FIELD));

    private final String ipamPoolId;

    private final String cidr;

    private final Integer netmaskLength;

    private final String clientToken;

    private final String description;

    private final Boolean previewNextCidr;

    private final List<String> disallowedCidrs;

    private AllocateIpamPoolCidrRequest(BuilderImpl builder) {
        super(builder);
        this.ipamPoolId = builder.ipamPoolId;
        this.cidr = builder.cidr;
        this.netmaskLength = builder.netmaskLength;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.previewNextCidr = builder.previewNextCidr;
        this.disallowedCidrs = builder.disallowedCidrs;
    }

    /**
     * <p>
     * The ID of the IPAM pool from which you would like to allocate a CIDR.
     * </p>
     * 
     * @return The ID of the IPAM pool from which you would like to allocate a CIDR.
     */
    public final String ipamPoolId() {
        return ipamPoolId;
    }

    /**
     * <p>
     * The CIDR you would like to allocate from the IPAM pool. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or
     * the CIDR.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the
     * CIDR and the DefaultNetmaskLength allocation rule will be ignored.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Possible values: Any available IPv4 or IPv6 CIDR.
     * </p>
     * 
     * @return The CIDR you would like to allocate from the IPAM pool. Note the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the
     *         NetmaskLength or the CIDR.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength
     *         or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Possible values: Any available IPv4 or IPv6 CIDR.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The netmask length of the CIDR you would like to allocate from the IPAM pool. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or
     * the CIDR.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the
     * CIDR and the DefaultNetmaskLength allocation rule will be ignored.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
     * </p>
     * 
     * @return The netmask length of the CIDR you would like to allocate from the IPAM pool. Note the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the
     *         NetmaskLength or the CIDR.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength
     *         or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0
     *         - 128.
     */
    public final Integer netmaskLength() {
        return netmaskLength;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A description for the allocation.
     * </p>
     * 
     * @return A description for the allocation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A preview of the next available CIDR in a pool.
     * </p>
     * 
     * @return A preview of the next available CIDR in a pool.
     */
    public final Boolean previewNextCidr() {
        return previewNextCidr;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisallowedCidrs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDisallowedCidrs() {
        return disallowedCidrs != null && !(disallowedCidrs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Exclude a particular CIDR range from being returned by the pool. Disallowed CIDRs are only allowed if using
     * netmask length for allocation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisallowedCidrs} method.
     * </p>
     * 
     * @return Exclude a particular CIDR range from being returned by the pool. Disallowed CIDRs are only allowed if
     *         using netmask length for allocation.
     */
    public final List<String> disallowedCidrs() {
        return disallowedCidrs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(netmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(previewNextCidr());
        hashCode = 31 * hashCode + Objects.hashCode(hasDisallowedCidrs() ? disallowedCidrs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateIpamPoolCidrRequest)) {
            return false;
        }
        AllocateIpamPoolCidrRequest other = (AllocateIpamPoolCidrRequest) obj;
        return Objects.equals(ipamPoolId(), other.ipamPoolId()) && Objects.equals(cidr(), other.cidr())
                && Objects.equals(netmaskLength(), other.netmaskLength()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(description(), other.description())
                && Objects.equals(previewNextCidr(), other.previewNextCidr())
                && hasDisallowedCidrs() == other.hasDisallowedCidrs()
                && Objects.equals(disallowedCidrs(), other.disallowedCidrs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllocateIpamPoolCidrRequest").add("IpamPoolId", ipamPoolId()).add("Cidr", cidr())
                .add("NetmaskLength", netmaskLength()).add("ClientToken", clientToken()).add("Description", description())
                .add("PreviewNextCidr", previewNextCidr())
                .add("DisallowedCidrs", hasDisallowedCidrs() ? disallowedCidrs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPoolId":
            return Optional.ofNullable(clazz.cast(ipamPoolId()));
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "NetmaskLength":
            return Optional.ofNullable(clazz.cast(netmaskLength()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PreviewNextCidr":
            return Optional.ofNullable(clazz.cast(previewNextCidr()));
        case "DisallowedCidrs":
            return Optional.ofNullable(clazz.cast(disallowedCidrs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocateIpamPoolCidrRequest, T> g) {
        return obj -> g.apply((AllocateIpamPoolCidrRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AllocateIpamPoolCidrRequest> {
        /**
         * <p>
         * The ID of the IPAM pool from which you would like to allocate a CIDR.
         * </p>
         * 
         * @param ipamPoolId
         *        The ID of the IPAM pool from which you would like to allocate a CIDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPoolId(String ipamPoolId);

        /**
         * <p>
         * The CIDR you would like to allocate from the IPAM pool. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the
         * NetmaskLength or the CIDR.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or
         * the CIDR and the DefaultNetmaskLength allocation rule will be ignored.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Possible values: Any available IPv4 or IPv6 CIDR.
         * </p>
         * 
         * @param cidr
         *        The CIDR you would like to allocate from the IPAM pool. Note the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the
         *        NetmaskLength or the CIDR.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the
         *        NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Possible values: Any available IPv4 or IPv6 CIDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The netmask length of the CIDR you would like to allocate from the IPAM pool. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the
         * NetmaskLength or the CIDR.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or
         * the CIDR and the DefaultNetmaskLength allocation rule will be ignored.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 -
         * 128.
         * </p>
         * 
         * @param netmaskLength
         *        The netmask length of the CIDR you would like to allocate from the IPAM pool. Note the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the
         *        NetmaskLength or the CIDR.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the
         *        NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses
         *        are 0 - 128.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netmaskLength(Integer netmaskLength);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A description for the allocation.
         * </p>
         * 
         * @param description
         *        A description for the allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A preview of the next available CIDR in a pool.
         * </p>
         * 
         * @param previewNextCidr
         *        A preview of the next available CIDR in a pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previewNextCidr(Boolean previewNextCidr);

        /**
         * <p>
         * Exclude a particular CIDR range from being returned by the pool. Disallowed CIDRs are only allowed if using
         * netmask length for allocation.
         * </p>
         * 
         * @param disallowedCidrs
         *        Exclude a particular CIDR range from being returned by the pool. Disallowed CIDRs are only allowed if
         *        using netmask length for allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disallowedCidrs(Collection<String> disallowedCidrs);

        /**
         * <p>
         * Exclude a particular CIDR range from being returned by the pool. Disallowed CIDRs are only allowed if using
         * netmask length for allocation.
         * </p>
         * 
         * @param disallowedCidrs
         *        Exclude a particular CIDR range from being returned by the pool. Disallowed CIDRs are only allowed if
         *        using netmask length for allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disallowedCidrs(String... disallowedCidrs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String ipamPoolId;

        private String cidr;

        private Integer netmaskLength;

        private String clientToken;

        private String description;

        private Boolean previewNextCidr;

        private List<String> disallowedCidrs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateIpamPoolCidrRequest model) {
            super(model);
            ipamPoolId(model.ipamPoolId);
            cidr(model.cidr);
            netmaskLength(model.netmaskLength);
            clientToken(model.clientToken);
            description(model.description);
            previewNextCidr(model.previewNextCidr);
            disallowedCidrs(model.disallowedCidrs);
        }

        public final String getIpamPoolId() {
            return ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final Integer getNetmaskLength() {
            return netmaskLength;
        }

        public final void setNetmaskLength(Integer netmaskLength) {
            this.netmaskLength = netmaskLength;
        }

        @Override
        public final Builder netmaskLength(Integer netmaskLength) {
            this.netmaskLength = netmaskLength;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getPreviewNextCidr() {
            return previewNextCidr;
        }

        public final void setPreviewNextCidr(Boolean previewNextCidr) {
            this.previewNextCidr = previewNextCidr;
        }

        @Override
        public final Builder previewNextCidr(Boolean previewNextCidr) {
            this.previewNextCidr = previewNextCidr;
            return this;
        }

        public final Collection<String> getDisallowedCidrs() {
            if (disallowedCidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return disallowedCidrs;
        }

        public final void setDisallowedCidrs(Collection<String> disallowedCidrs) {
            this.disallowedCidrs = IpamPoolAllocationDisallowedCidrsCopier.copy(disallowedCidrs);
        }

        @Override
        public final Builder disallowedCidrs(Collection<String> disallowedCidrs) {
            this.disallowedCidrs = IpamPoolAllocationDisallowedCidrsCopier.copy(disallowedCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disallowedCidrs(String... disallowedCidrs) {
            disallowedCidrs(Arrays.asList(disallowedCidrs));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocateIpamPoolCidrRequest build() {
            return new AllocateIpamPoolCidrRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
