/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.StaleSecurityGroup;

public class DescribeStaleSecurityGroupsIterable
implements SdkIterable<DescribeStaleSecurityGroupsResponse> {
    private final Ec2Client client;
    private final DescribeStaleSecurityGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeStaleSecurityGroupsIterable(Ec2Client client, DescribeStaleSecurityGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeStaleSecurityGroupsResponseFetcher();
    }

    public Iterator<DescribeStaleSecurityGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StaleSecurityGroup> staleSecurityGroupSet() {
        Function<DescribeStaleSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.staleSecurityGroupSet() != null) {
                return response.staleSecurityGroupSet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeStaleSecurityGroupsResponseFetcher
    implements SyncPageFetcher<DescribeStaleSecurityGroupsResponse> {
        private DescribeStaleSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStaleSecurityGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeStaleSecurityGroupsResponse nextPage(DescribeStaleSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStaleSecurityGroupsIterable.this.client.describeStaleSecurityGroups(DescribeStaleSecurityGroupsIterable.this.firstRequest);
            }
            return DescribeStaleSecurityGroupsIterable.this.client.describeStaleSecurityGroups((DescribeStaleSecurityGroupsRequest)((Object)DescribeStaleSecurityGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

