/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesResponse;
import software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScope;

public class DescribeNetworkInsightsAccessScopesPublisher
implements SdkPublisher<DescribeNetworkInsightsAccessScopesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeNetworkInsightsAccessScopesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeNetworkInsightsAccessScopesPublisher(Ec2AsyncClient client, DescribeNetworkInsightsAccessScopesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeNetworkInsightsAccessScopesPublisher(Ec2AsyncClient client, DescribeNetworkInsightsAccessScopesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeNetworkInsightsAccessScopesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeNetworkInsightsAccessScopesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NetworkInsightsAccessScope> networkInsightsAccessScopes() {
        Function<DescribeNetworkInsightsAccessScopesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkInsightsAccessScopes() != null) {
                return response.networkInsightsAccessScopes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeNetworkInsightsAccessScopesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeNetworkInsightsAccessScopesResponseFetcher
    implements AsyncPageFetcher<DescribeNetworkInsightsAccessScopesResponse> {
        private DescribeNetworkInsightsAccessScopesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNetworkInsightsAccessScopesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeNetworkInsightsAccessScopesResponse> nextPage(DescribeNetworkInsightsAccessScopesResponse previousPage) {
            if (previousPage == null) {
                return DescribeNetworkInsightsAccessScopesPublisher.this.client.describeNetworkInsightsAccessScopes(DescribeNetworkInsightsAccessScopesPublisher.this.firstRequest);
            }
            return DescribeNetworkInsightsAccessScopesPublisher.this.client.describeNetworkInsightsAccessScopes((DescribeNetworkInsightsAccessScopesRequest)((Object)DescribeNetworkInsightsAccessScopesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

