/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NatGatewayAddress
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NatGatewayAddress> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationId").getter(NatGatewayAddress.getter(NatGatewayAddress::allocationId)).setter(NatGatewayAddress.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("allocationId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(NatGatewayAddress.getter(NatGatewayAddress::networkInterfaceId)).setter(NatGatewayAddress.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> PRIVATE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIp").getter(NatGatewayAddress.getter(NatGatewayAddress::privateIp)).setter(NatGatewayAddress.setter(Builder::privateIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIp").unmarshallLocationName("privateIp").build()}).build();
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIp").getter(NatGatewayAddress.getter(NatGatewayAddress::publicIp)).setter(NatGatewayAddress.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").unmarshallLocationName("publicIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_FIELD, PUBLIC_IP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String allocationId;
    private final String networkInterfaceId;
    private final String privateIp;
    private final String publicIp;

    private NatGatewayAddress(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIp = builder.privateIp;
        this.publicIp = builder.publicIp;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String privateIp() {
        return this.privateIp;
    }

    public final String publicIp() {
        return this.publicIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NatGatewayAddress)) {
            return false;
        }
        NatGatewayAddress other = (NatGatewayAddress)obj;
        return Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.privateIp(), other.privateIp()) && Objects.equals(this.publicIp(), other.publicIp());
    }

    public final String toString() {
        return ToString.builder((String)"NatGatewayAddress").add("AllocationId", (Object)this.allocationId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("PrivateIp", (Object)this.privateIp()).add("PublicIp", (Object)this.publicIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "PrivateIp": {
                return Optional.ofNullable(clazz.cast(this.privateIp()));
            }
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NatGatewayAddress, T> g) {
        return obj -> g.apply((NatGatewayAddress)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationId;
        private String networkInterfaceId;
        private String privateIp;
        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(NatGatewayAddress model) {
            this.allocationId(model.allocationId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.privateIp(model.privateIp);
            this.publicIp(model.publicIp);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getPrivateIp() {
            return this.privateIp;
        }

        public final void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        @Override
        public final Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public NatGatewayAddress build() {
            return new NatGatewayAddress(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NatGatewayAddress> {
        public Builder allocationId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIp(String var1);

        public Builder publicIp(String var1);
    }
}

